/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ui.services.CodingServiceComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class CodingContentProposalProvider
implements IContentProposalProvider {
    private Optional<String> selectedSystem;
    private HashMap<String, ICoding> labelToCoding = new HashMap();

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList ret = new ArrayList();
        if (contents != null && !contents.isEmpty()) {
            this.labelToCoding.keySet().stream().forEach(label -> {
                String match = contents.toLowerCase();
                if (label.toLowerCase().contains(match)) {
                    ret.add(new ContentProposal(label));
                }
            });
        }
        return ret.toArray(new IContentProposal[ret.size()]);
    }

    public String toLabel(ICoding coding) {
        return "[" + coding.getCode() + "] " + coding.getDisplay();
    }

    public Optional<ICoding> fromLabel(String label) {
        return Optional.ofNullable(this.labelToCoding.get(label));
    }

    public void setSelectedSystem(Optional<String> selectedSystem) {
        this.selectedSystem = selectedSystem;
        this.clearCache();
        this.buildCache();
    }

    private void clearCache() {
        this.labelToCoding.clear();
    }

    private void buildCache() {
        if (this.selectedSystem.isPresent()) {
            List codes = CodingServiceComponent.getService().getAvailableCodes(this.selectedSystem.get());
            codes.parallelStream().forEach(iCoding -> {
                String label = this.toLabel((ICoding)iCoding);
                this.labelToCoding.put(label, (ICoding)iCoding);
            });
        }
    }

    public Optional<ICoding> getCodingForProposal(IContentProposal proposal) {
        String label = proposal.getContent();
        if (label != null && !label.isEmpty()) {
            return this.fromLabel(label);
        }
        return Optional.empty();
    }
}

