/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.model.AbstractBeanAdapter;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ObservationBeanAdapter
extends AbstractBeanAdapter<IObservation> {
    public ObservationBeanAdapter(IObservation observation) {
        this.finding = observation;
        if (StringUtils.isBlank((CharSequence)observation.getPatientId())) {
            this.init();
        }
    }

    public ObservationBeanAdapter category(IObservation.ObservationCategory category) {
        ((IObservation)this.finding).setCategory(category);
        return this;
    }

    public ObservationBeanAdapter coding(ICoding coding) {
        ((IObservation)this.finding).setCoding(Collections.singletonList(coding));
        return this;
    }

    public IObservation.ObservationCategory getCategory() {
        return ((IObservation)this.finding).getCategory();
    }

    public void setCategory(IObservation.ObservationCategory category) {
        ((IObservation)this.finding).setCategory(category);
        this.autoSave();
    }

    public String getStringValue() {
        return ((IObservation)this.finding).getStringValue().orElse("");
    }

    public void setStringValue(String value) {
        ((IObservation)this.finding).setStringValue(value);
        this.autoSave();
    }

    public List<ICoding> getCoding() {
        return ((IObservation)this.finding).getCoding();
    }

    public void setCoding(List<ICoding> coding) {
        ((IObservation)this.finding).setCoding(coding);
        this.autoSave();
    }

    public void setEffectiveTime(LocalDateTime date) {
        ((IObservation)this.finding).setEffectiveTime(date);
        this.autoSave();
    }

    public LocalDateTime getEffectiveTime() {
        return ((IObservation)this.finding).getEffectiveTime().orElse(null);
    }
}

