/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IXid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class LocalCoding
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.LocalCoding>
implements ILocalCoding {
    private static String MAPPED_SEPARATOR = "||";
    private static String MAPPED_SEPARATOR_SPLITTER = "\\|\\|";
    private static String MAPPED_FIELD_SEPARATOR = "^";

    public LocalCoding(ch.elexis.core.jpa.entities.LocalCoding entity) {
        super((EntityWithId)entity);
    }

    public String getSystem() {
        return CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem();
    }

    public List<ICoding> getMappedCodes() {
        String mappedString = ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).getMapped();
        if (mappedString != null && !mappedString.isEmpty()) {
            return this.getMappedCodingFromString(mappedString);
        }
        return Collections.emptyList();
    }

    private List<ICoding> getMappedCodingFromString(String encoded) {
        String[] codeStrings = encoded.split(MAPPED_SEPARATOR_SPLITTER);
        if (codeStrings != null && codeStrings.length > 0) {
            ArrayList<ICoding> ret = new ArrayList<ICoding>();
            String[] stringArray = codeStrings;
            int n = codeStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.getCodingFromString(string).ifPresent(c -> {
                    boolean bl = ret.add((ICoding)c);
                });
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public void setMappedCodes(List<ICoding> mappedCodes) {
        String encoded = "";
        if (mappedCodes != null && !mappedCodes.isEmpty()) {
            encoded = this.getMappedCodingAsString(mappedCodes);
        }
        ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).setMapped(encoded);
    }

    private String getMappedCodingAsString(List<ICoding> mappedCoding) {
        StringBuilder sb = new StringBuilder();
        for (ICoding iCoding : mappedCoding) {
            if (sb.length() > 0) {
                sb.append(MAPPED_SEPARATOR);
            }
            sb.append(this.getAsString(iCoding));
        }
        return sb.toString();
    }

    private String getAsString(ICoding coding) {
        return coding.getSystem() + MAPPED_FIELD_SEPARATOR + coding.getCode() + MAPPED_FIELD_SEPARATOR + coding.getDisplay();
    }

    private Optional<ICoding> getCodingFromString(String encoded) {
        String[] codingParts = encoded.split("\\" + MAPPED_FIELD_SEPARATOR);
        if (codingParts != null && codingParts.length > 1) {
            if (codingParts.length == 2) {
                return Optional.of(new TransientCoding(codingParts[0], codingParts[1], ""));
            }
            if (codingParts.length == 3) {
                return Optional.of(new TransientCoding(codingParts[0], codingParts[1], codingParts[2]));
            }
        }
        return Optional.empty();
    }

    public void setCode(String code) {
        ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).setCode(code);
    }

    public void setDisplay(String display) {
        ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).setDisplay(display);
    }

    public String getCode() {
        return ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).getCode();
    }

    public String getDisplay() {
        return ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).getDisplay();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }

    public void setPrio(int prio) {
        ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).setPrio(prio);
    }

    public int getPrio() {
        return ((ch.elexis.core.jpa.entities.LocalCoding)this.getEntity()).getPrio();
    }
}

