/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.fhir.model.AbstractFindingModelAdapter;
import ch.elexis.core.findings.fhir.model.service.DocumentStoreHolder;
import ch.elexis.core.findings.util.fhir.accessor.DocumentReferenceAccessor;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IXid;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;

public class DocumentReference
extends AbstractFindingModelAdapter<ch.elexis.core.jpa.entities.DocumentReference>
implements IDocumentReference {
    private DocumentReferenceAccessor accessor = new DocumentReferenceAccessor();

    public DocumentReference(ch.elexis.core.jpa.entities.DocumentReference entity) {
        super(entity);
    }

    public String getPatientId() {
        return ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getPatientId();
    }

    public void setPatientId(String patientId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.r4.model.DocumentReference fhirDocumentReference = (org.hl7.fhir.r4.model.DocumentReference)resource.get();
            fhirDocumentReference.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setPatientId(patientId);
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getContent();
    }

    public void setRawContent(String content) {
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setContent(content);
    }

    public IDocument getDocument() {
        return DocumentStoreHolder.getDocument(((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getDocumentStoreId(), ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getDocumentId()).orElse(null);
    }

    public void setDocument(IDocument document) {
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setDocumentStoreId(document.getStoreId());
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setDocumentId(document.getId());
        if (document.getPatient() != null) {
            this.setPatientId(document.getPatient().getId());
        }
        if (document.getAuthor() != null) {
            this.setAuthorId(document.getAuthor().getId());
        }
    }

    public ICoding getDocumentClass() {
        return this.loadResource().map(i -> this.accessor.getDocumentClass((DomainResource)i)).get().stream().findFirst().orElse(null);
    }

    public void setDocumentClass(ICoding coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setDocumentClass((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public ICoding getPracticeSetting() {
        return this.loadResource().map(i -> this.accessor.getPracticeSetting((DomainResource)i)).get().stream().findFirst().orElse(null);
    }

    public void setPracticeSetting(ICoding coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setPracticeSetting((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public ICoding getFacilityType() {
        return this.loadResource().map(i -> this.accessor.getFacilityType((DomainResource)i)).get().stream().findFirst().orElse(null);
    }

    public void setFacilityType(ICoding coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setFacilityType((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }

    public String getAuthorId() {
        return ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).getAuthorId();
    }

    public void setAuthorId(String authorId) {
        ((ch.elexis.core.jpa.entities.DocumentReference)this.getEntity()).setAuthorId(authorId);
    }
}

