/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.fhir.model.AbstractFindingModelAdapter;
import ch.elexis.core.findings.util.fhir.accessor.ConditionAccessor;
import ch.elexis.core.model.IXid;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;

public class Condition
extends AbstractFindingModelAdapter<ch.elexis.core.jpa.entities.Condition>
implements ICondition {
    private ConditionAccessor accessor = new ConditionAccessor();

    public Condition(ch.elexis.core.jpa.entities.Condition entity) {
        super(entity);
    }

    public String getPatientId() {
        return ((ch.elexis.core.jpa.entities.Condition)this.getEntity()).getPatientId();
    }

    public void setPatientId(String patientId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setPatientId((DomainResource)resource.get(), patientId);
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.Condition)this.getEntity()).setPatientId(patientId);
    }

    public List<ICoding> getCoding() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCoding((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public void setCoding(List<ICoding> coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCoding((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public Optional<LocalDate> getDateRecorded() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getDateRecorded((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setDateRecorded(LocalDate date) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setDateRecorded((DomainResource)resource.get(), date);
            this.saveResource(resource.get());
        }
    }

    public ICondition.ConditionCategory getCategory() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCategory((DomainResource)resource.get());
        }
        return ICondition.ConditionCategory.UNKNOWN;
    }

    public void setCategory(ICondition.ConditionCategory category) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCategory((DomainResource)resource.get(), category);
            this.saveResource(resource.get());
        }
    }

    public ICondition.ConditionStatus getStatus() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStatus((DomainResource)resource.get());
        }
        return ICondition.ConditionStatus.UNKNOWN;
    }

    public void setStatus(ICondition.ConditionStatus status) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && status != ICondition.ConditionStatus.UNKNOWN) {
            this.accessor.setStatus((DomainResource)resource.get(), status);
            this.saveResource(resource.get());
        }
    }

    public void setStart(String start) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setStart((DomainResource)resource.get(), start);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getStart() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStart((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setEnd(String end) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setEnd((DomainResource)resource.get(), end);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getEnd() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getEnd((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void addNote(String text) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.addNote((DomainResource)resource.get(), text);
            this.saveResource(resource.get());
        }
    }

    public void removeNote(String text) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.removeNote((DomainResource)resource.get(), text);
            this.saveResource(resource.get());
        }
    }

    public List<String> getNotes() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getNotes((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return ((ch.elexis.core.jpa.entities.Condition)this.getEntity()).getContent();
    }

    public void setRawContent(String content) {
        ((ch.elexis.core.jpa.entities.Condition)this.getEntity()).setContent(content);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }
}

