/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model.service;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.codes.ICodingContribution;
import ch.elexis.core.findings.codes.ILocalCodingContribution;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class LocalCodingContribution
implements ICodingContribution,
ILocalCodingContribution {
    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;

    public String getCodeSystem() {
        return CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem();
    }

    public List<ICoding> getCodes() {
        IQuery query = this.findingsModelService.getQuery(ILocalCoding.class);
        query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION");
        return new ArrayList<ICoding>(query.execute());
    }

    public void addCoding(ICoding coding) {
        Optional<ICoding> exists;
        if (coding.getSystem().equals(this.getCodeSystem()) && !(exists = this.getCodingByCode(coding.getCode())).isPresent()) {
            ILocalCoding localCoding = (ILocalCoding)this.findingsModelService.create(ILocalCoding.class);
            localCoding.setCode(coding.getCode());
            localCoding.setDisplay(coding.getDisplay());
            this.findingsModelService.save((Identifiable)localCoding);
        }
    }

    private Optional<ICoding> getCodingByCode(String code) {
        IQuery query = this.findingsModelService.getQuery(ILocalCoding.class);
        query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION");
        if (code != null && code.isEmpty()) {
            query.startGroup();
            query.or("code", IQuery.COMPARATOR.EQUALS, (Object)code);
            query.or("code", IQuery.COMPARATOR.EQUALS, null);
            query.andJoinGroups();
        } else {
            query.and("code", IQuery.COMPARATOR.EQUALS, (Object)code);
        }
        List existing = query.execute();
        if (!existing.isEmpty()) {
            return Optional.of((ICoding)existing.get(0));
        }
        return Optional.empty();
    }

    public void removeCoding(ICoding coding) {
        if (coding.getSystem().equals(this.getCodeSystem())) {
            Optional<ICoding> exists = this.getCodingByCode(coding.getCode());
            exists.ifPresent(existing -> this.findingsModelService.delete((Deleteable)((ILocalCoding)existing)));
        }
    }

    public Optional<ICoding> getCode(String code) {
        return this.getCodingByCode(code);
    }
}

