/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.model;

import ca.uhn.fhir.model.primitive.IdDt;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.fhir.model.AbstractFindingModelAdapter;
import ch.elexis.core.findings.util.fhir.accessor.EncounterAccessor;
import ch.elexis.core.model.IXid;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;

public class Encounter
extends AbstractFindingModelAdapter<ch.elexis.core.jpa.entities.Encounter>
implements IEncounter {
    private EncounterAccessor accessor = new EncounterAccessor();

    public Encounter(ch.elexis.core.jpa.entities.Encounter entity) {
        super(entity);
    }

    public String getPatientId() {
        return ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).getPatientId();
    }

    public void setPatientId(String patientId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            org.hl7.fhir.r4.model.Encounter fhirEncounter = (org.hl7.fhir.r4.model.Encounter)resource.get();
            fhirEncounter.setSubject(new Reference((IIdType)new IdDt("Patient", patientId)));
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).setPatientId(patientId);
    }

    public Optional<LocalDateTime> getStartTime() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStartTime((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setStartTime(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setStartTime((DomainResource)resource.get(), time);
            this.saveResource(resource.get());
        }
    }

    public Optional<LocalDateTime> getEndTime() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getEndTime((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setEndTime(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setEndTime((DomainResource)resource.get(), time);
            this.saveResource(resource.get());
        }
    }

    public String getConsultationId() {
        return ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).getConsultationId();
    }

    public void setConsultationId(String consultationId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setConsultationId((DomainResource)resource.get(), consultationId);
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).setConsultationId(consultationId);
    }

    public String getMandatorId() {
        return ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).getMandatorId();
    }

    public void setMandatorId(String mandatorId) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setMandatorId((DomainResource)resource.get(), mandatorId);
            this.saveResource(resource.get());
        }
        ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).setMandatorId(mandatorId);
    }

    public void setType(List<ICoding> coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setType((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public List<ICoding> getType() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getType((DomainResource)resource.get());
        }
        return new ArrayList<ICoding>();
    }

    public List<ICondition> getIndication() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getIndication((DomainResource)resource.get());
        }
        return new ArrayList<ICondition>();
    }

    public void setIndication(List<ICondition> indication) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setIndication((DomainResource)resource.get(), indication);
            this.saveResource(resource.get());
        }
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).getContent();
    }

    public void setRawContent(String content) {
        ((ch.elexis.core.jpa.entities.Encounter)this.getEntity()).setContent(content);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    public IXid getXid(String domain) {
        return null;
    }
}

