# UserApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**deleteGlobalConfigurationValueByKey**](UserApi.md#deleteGlobalConfigurationValueByKey) | **DELETE** /api/v1/user/config/global | Delete Global Configuration Value By Key |
| [**deleteUserContactConfigurationEntryByKey**](UserApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key |
| [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](UserApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches. |
| [**getExecutiveDoctorsWorkingFor**](UserApi.md#getExecutiveDoctorsWorkingFor) | **GET** /api/v1/user/executive-doctors-working-for | Get executive doctors user is working for |
| [**getGlobalConfigurationValueByKey**](UserApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key |
| [**getUserContactConfigurationValueByKey**](UserApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key |
| [**getUserInfo**](UserApi.md#getUserInfo) | **GET** /api/v1/user/info | Get user information |
| [**setGlobalConfigurationValueByKey**](UserApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key |
| [**setUserContactConfigurationValueByKey**](UserApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key |



## deleteGlobalConfigurationValueByKey

> deleteGlobalConfigurationValueByKey(key)

Delete Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteGlobalConfigurationValueByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#deleteGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## deleteUserContactConfigurationEntryByKey

> deleteUserContactConfigurationEntryByKey(key)

Delete User Contact Configuration Entry By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteUserContactConfigurationEntryByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#deleteUserContactConfigurationEntryByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findGlobalConfigurationDirectSubnodeKeysForGivenKey

> List&lt;String&gt; findGlobalConfigurationDirectSubnodeKeysForGivenKey(key)

Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            List<String> result = apiInstance.findGlobalConfigurationDirectSubnodeKeysForGivenKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#findGlobalConfigurationDirectSubnodeKeysForGivenKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**List&lt;String&gt;**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getExecutiveDoctorsWorkingFor

> Set&lt;String&gt; getExecutiveDoctorsWorkingFor()

Get executive doctors user is working for

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;Retrieves the contact ids of the executive doctors the current user is working for

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        try {
            Set<String> result = apiInstance.getExecutiveDoctorsWorkingFor();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getExecutiveDoctorsWorkingFor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**Set&lt;String&gt;**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getGlobalConfigurationValueByKey

> String getGlobalConfigurationValueByKey(key)

Get Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            String result = apiInstance.getGlobalConfigurationValueByKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**String**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserContactConfigurationValueByKey

> String getUserContactConfigurationValueByKey(key, contactId)

Get User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String contactId = "contactId_example"; // String | Target contact to fetch value for. Limited to self and contact user is aobo
        try {
            String result = apiInstance.getUserContactConfigurationValueByKey(key, contactId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **contactId** | **String**| Target contact to fetch value for. Limited to self and contact user is aobo | [optional] |

### Return type

**String**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserInfo

> User getUserInfo(resolveViaKeycloak, targetUserId)

Get user information

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;Get User information

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        Boolean resolveViaKeycloak = false; // Boolean | If true resolve info via keycloak, by default resolves via token
        String targetUserId = "targetUserId_example"; // String | Target user (only ict-administrator) (implies resolveViaKeycloak)
        try {
            User result = apiInstance.getUserInfo(resolveViaKeycloak, targetUserId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getUserInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **resolveViaKeycloak** | **Boolean**| If true resolve info via keycloak, by default resolves via token | [optional] [default to false] |
| **targetUserId** | **String**| Target user (only ict-administrator) (implies resolveViaKeycloak) | [optional] |

### Return type

[**User**](User.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setGlobalConfigurationValueByKey

> setGlobalConfigurationValueByKey(key, body)

Set Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            apiInstance.setGlobalConfigurationValueByKey(key, body);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#setGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setUserContactConfigurationValueByKey

> setUserContactConfigurationValueByKey(key, body)

Set User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            apiInstance.setUserContactConfigurationValueByKey(key, body);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#setUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

