# StockServiceV1Api

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createStock**](StockServiceV1Api.md#createStock) | **POST** /api/v1/services/stock | Create a Stock |
| [**listStockEntries**](StockServiceV1Api.md#listStockEntries) | **GET** /api/v1/services/stock/{stockId} | List all stock entries for the given stock |
| [**listStocks**](StockServiceV1Api.md#listStocks) | **GET** /api/v1/services/stock | List the defined stocks (excluding patient-stocks) |
| [**outlayArticleOnStockCommissioningSystem**](StockServiceV1Api.md#outlayArticleOnStockCommissioningSystem) | **PUT** /api/v1/services/stock/{stockId}/$scs-outlay | Outlay a single element of a given stockEntryId (if stockId is a scs) |
| [**startStockCommissioningSystem**](StockServiceV1Api.md#startStockCommissioningSystem) | **PUT** /api/v1/services/stock/{stockId}/$scs-start | Start stock commissioning system (if stockId is a scs) |
| [**stopStockCommissioningSystem**](StockServiceV1Api.md#stopStockCommissioningSystem) | **PUT** /api/v1/services/stock/{stockId}/$scs-stop | Stop stock commissioning system (if stockId is a scs) |
| [**synchronizeStockFromStockCommissioningSystem**](StockServiceV1Api.md#synchronizeStockFromStockCommissioningSystem) | **PUT** /api/v1/services/stock/{stockId}/$scs-sync | Synchronize the stock state of the commissioning system with Elexis (if stockId is a scs) |



## createStock

> Stock createStock(stock)

Create a Stock

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.StockServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        StockServiceV1Api apiInstance = new StockServiceV1Api(defaultClient);
        Stock stock = new Stock(); // Stock | 
        try {
            Stock result = apiInstance.createStock(stock);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling StockServiceV1Api#createStock");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **stock** | [**Stock**](Stock.md)|  | |

### Return type

[**Stock**](Stock.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## listStockEntries

> List&lt;StockEntry&gt; listStockEntries(stockId)

List all stock entries for the given stock

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.StockServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        StockServiceV1Api apiInstance = new StockServiceV1Api(defaultClient);
        String stockId = "stockId_example"; // String | 
        try {
            List<StockEntry> result = apiInstance.listStockEntries(stockId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling StockServiceV1Api#listStockEntries");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **stockId** | **String**|  | |

### Return type

[**List&lt;StockEntry&gt;**](StockEntry.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## listStocks

> List&lt;Stock&gt; listStocks()

List the defined stocks (excluding patient-stocks)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.StockServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        StockServiceV1Api apiInstance = new StockServiceV1Api(defaultClient);
        try {
            List<Stock> result = apiInstance.listStocks();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling StockServiceV1Api#listStocks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;Stock&gt;**](Stock.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## outlayArticleOnStockCommissioningSystem

> outlayArticleOnStockCommissioningSystem(stockId, stockEntryId)

Outlay a single element of a given stockEntryId (if stockId is a scs)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.StockServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        StockServiceV1Api apiInstance = new StockServiceV1Api(defaultClient);
        String stockId = "stockId_example"; // String | 
        String stockEntryId = "stockEntryId_example"; // String | 
        try {
            apiInstance.outlayArticleOnStockCommissioningSystem(stockId, stockEntryId);
        } catch (ApiException e) {
            System.err.println("Exception when calling StockServiceV1Api#outlayArticleOnStockCommissioningSystem");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **stockId** | **String**|  | |
| **stockEntryId** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## startStockCommissioningSystem

> startStockCommissioningSystem(stockId)

Start stock commissioning system (if stockId is a scs)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.StockServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        StockServiceV1Api apiInstance = new StockServiceV1Api(defaultClient);
        String stockId = "stockId_example"; // String | 
        try {
            apiInstance.startStockCommissioningSystem(stockId);
        } catch (ApiException e) {
            System.err.println("Exception when calling StockServiceV1Api#startStockCommissioningSystem");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **stockId** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## stopStockCommissioningSystem

> stopStockCommissioningSystem(stockId)

Stop stock commissioning system (if stockId is a scs)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.StockServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        StockServiceV1Api apiInstance = new StockServiceV1Api(defaultClient);
        String stockId = "stockId_example"; // String | 
        try {
            apiInstance.stopStockCommissioningSystem(stockId);
        } catch (ApiException e) {
            System.err.println("Exception when calling StockServiceV1Api#stopStockCommissioningSystem");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **stockId** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## synchronizeStockFromStockCommissioningSystem

> synchronizeStockFromStockCommissioningSystem(stockId)

Synchronize the stock state of the commissioning system with Elexis (if stockId is a scs)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.StockServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        StockServiceV1Api apiInstance = new StockServiceV1Api(defaultClient);
        String stockId = "stockId_example"; // String | 
        try {
            apiInstance.synchronizeStockFromStockCommissioningSystem(stockId);
        } catch (ApiException e) {
            System.err.println("Exception when calling StockServiceV1Api#synchronizeStockFromStockCommissioningSystem");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **stockId** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

