# LegacyApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**acquireOrReleaseLocks**](LegacyApi.md#acquireOrReleaseLocks) | **POST** /services/elexis/lockservice/acquireOrReleaseLocks |  |
| [**getLockInfo**](LegacyApi.md#getLockInfo) | **GET** /services/elexis/lockservice/lockInfo |  |
| [**isLocked**](LegacyApi.md#isLocked) | **POST** /services/elexis/lockservice/isLocked |  |
| [**postEvent**](LegacyApi.md#postEvent) | **POST** /services/elexis/eventservice/postEvent |  |



## acquireOrReleaseLocks

> LockResponse acquireOrReleaseLocks(lockRequest)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        LockRequest lockRequest = new LockRequest(); // LockRequest | 
        try {
            LockResponse result = apiInstance.acquireOrReleaseLocks(lockRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#acquireOrReleaseLocks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lockRequest** | [**LockRequest**](LockRequest.md)|  | |

### Return type

[**LockResponse**](LockResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## getLockInfo

> LockInfo getLockInfo(objectId)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        String objectId = "objectId_example"; // String | 
        try {
            LockInfo result = apiInstance.getLockInfo(objectId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#getLockInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **objectId** | **String**|  | [optional] |

### Return type

[**LockInfo**](LockInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## isLocked

> Boolean isLocked(lockRequest)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        LockRequest lockRequest = new LockRequest(); // LockRequest | 
        try {
            Boolean result = apiInstance.isLocked(lockRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#isLocked");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lockRequest** | [**LockRequest**](LockRequest.md)|  | |

### Return type

**Boolean**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |


## postEvent

> postEvent(elexisEvent)



### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.LegacyApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");

        LegacyApi apiInstance = new LegacyApi(defaultClient);
        ElexisEvent elexisEvent = new ElexisEvent(); // ElexisEvent | 
        try {
            apiInstance.postEvent(elexisEvent);
        } catch (ApiException e) {
            System.err.println("Exception when calling LegacyApi#postEvent");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **elexisEvent** | [**ElexisEvent**](ElexisEvent.md)|  | |

### Return type

null (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/xml
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |

