# InstanceServiceV1Api

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**clearInstanceStatus**](InstanceServiceV1Api.md#clearInstanceStatus) | **PUT** /api/v1/services/instance/$clear | Clear Instance Status |
| [**getInstanceStatus**](InstanceServiceV1Api.md#getInstanceStatus) | **GET** /api/v1/services/instance | Get Instance Status |



## clearInstanceStatus

> clearInstanceStatus()

Clear Instance Status

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.InstanceServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        InstanceServiceV1Api apiInstance = new InstanceServiceV1Api(defaultClient);
        try {
            apiInstance.clearInstanceStatus();
        } catch (ApiException e) {
            System.err.println("Exception when calling InstanceServiceV1Api#clearInstanceStatus");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getInstanceStatus

> List&lt;InstanceStatus&gt; getInstanceStatus()

Get Instance Status

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.InstanceServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        InstanceServiceV1Api apiInstance = new InstanceServiceV1Api(defaultClient);
        try {
            List<InstanceStatus> result = apiInstance.getInstanceStatus();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling InstanceServiceV1Api#getInstanceStatus");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;InstanceStatus&gt;**](InstanceStatus.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

