# ConfigApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**deleteGlobalConfigurationValueByKey**](ConfigApi.md#deleteGlobalConfigurationValueByKey) | **DELETE** /api/v1/user/config/global | Delete Global Configuration Value By Key |
| [**deleteUserContactConfigurationEntryByKey**](ConfigApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key |
| [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](ConfigApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches. |
| [**getContactConfigurationEntries**](ConfigApi.md#getContactConfigurationEntries) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries |
| [**getGlobalConfiguration**](ConfigApi.md#getGlobalConfiguration) | **GET** /api/v1/management/config/global | Return the global configuration tree |
| [**getGlobalConfigurationValueByKey**](ConfigApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key |
| [**getUserContactConfigurationAsTree**](ConfigApi.md#getUserContactConfigurationAsTree) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values. |
| [**getUserContactConfigurationValueByKey**](ConfigApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key |
| [**setContactConfiguration**](ConfigApi.md#setContactConfiguration) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration |
| [**setGlobalConfigurationValueByKey**](ConfigApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key |
| [**setUserContactConfigurationValueByKey**](ConfigApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key |
| [**updateGlobalConfigByJson**](ConfigApi.md#updateGlobalConfigByJson) | **PUT** /api/v1/management/config/global | Update Global Config By Json |



## deleteGlobalConfigurationValueByKey

> deleteGlobalConfigurationValueByKey(key)

Delete Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteGlobalConfigurationValueByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#deleteGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## deleteUserContactConfigurationEntryByKey

> deleteUserContactConfigurationEntryByKey(key)

Delete User Contact Configuration Entry By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteUserContactConfigurationEntryByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#deleteUserContactConfigurationEntryByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findGlobalConfigurationDirectSubnodeKeysForGivenKey

> List&lt;String&gt; findGlobalConfigurationDirectSubnodeKeysForGivenKey(key)

Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            List<String> result = apiInstance.findGlobalConfigurationDirectSubnodeKeysForGivenKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#findGlobalConfigurationDirectSubnodeKeysForGivenKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**List&lt;String&gt;**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getContactConfigurationEntries

> Map&lt;String, String&gt; getContactConfigurationEntries(contactid)

Get Contact Configuration Entries

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String contactid = "contactid_example"; // String | 
        try {
            Map<String, String> result = apiInstance.getContactConfigurationEntries(contactid);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getContactConfigurationEntries");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **contactid** | **String**|  | |

### Return type

**Map&lt;String, String&gt;**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getGlobalConfiguration

> getGlobalConfiguration(format)

Return the global configuration tree

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String format = "json"; // String | The format of the response, json (key, values) or json-tree (defaults to json)
        try {
            apiInstance.getGlobalConfiguration(format);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getGlobalConfiguration");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **format** | **String**| The format of the response, json (key, values) or json-tree (defaults to json) | [optional] [default to json] |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getGlobalConfigurationValueByKey

> String getGlobalConfigurationValueByKey(key)

Get Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            String result = apiInstance.getGlobalConfigurationValueByKey(key);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |

### Return type

**String**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserContactConfigurationAsTree

> getUserContactConfigurationAsTree(userContactId, userId)

Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String userContactId = "userContactId_example"; // String | The id of a users associated-contact
        String userId = "userId_example"; // String | The id of a user (its associated contact will be used). Setting this will override `user-contact-id`
        try {
            apiInstance.getUserContactConfigurationAsTree(userContactId, userId);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getUserContactConfigurationAsTree");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userContactId** | **String**| The id of a users associated-contact | [optional] |
| **userId** | **String**| The id of a user (its associated contact will be used). Setting this will override &#x60;user-contact-id&#x60; | [optional] |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUserContactConfigurationValueByKey

> String getUserContactConfigurationValueByKey(key, contactId)

Get User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String contactId = "contactId_example"; // String | Target contact to fetch value for. Limited to self and contact user is aobo
        try {
            String result = apiInstance.getUserContactConfigurationValueByKey(key, contactId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#getUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **contactId** | **String**| Target contact to fetch value for. Limited to self and contact user is aobo | [optional] |

### Return type

**String**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setContactConfiguration

> setContactConfiguration(contactid, requestBody)

Update contact configuration

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String contactid = "contactid_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            apiInstance.setContactConfiguration(contactid, requestBody);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setContactConfiguration");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **contactid** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## setGlobalConfigurationValueByKey

> setGlobalConfigurationValueByKey(key, body)

Set Global Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            apiInstance.setGlobalConfigurationValueByKey(key, body);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setUserContactConfigurationValueByKey

> setUserContactConfigurationValueByKey(key, body)

Set User Contact Configuration Value By Key

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,user&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        String body = "body_example"; // String | 
        try {
            apiInstance.setUserContactConfigurationValueByKey(key, body);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#setUserContactConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **key** | **String**|  | |
| **body** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## updateGlobalConfigByJson

> updateGlobalConfigByJson(body)

Update Global Config By Json

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.ConfigApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String body = "body_example"; // String | A (partial) config json. Keys with value `null` will be deleted. Add `\"dry-run\": true` to perform a dry-run.
        try {
            apiInstance.updateGlobalConfigByJson(body);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#updateGlobalConfigByJson");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | **String**| A (partial) config json. Keys with value &#x60;null&#x60; will be deleted. Add &#x60;\&quot;dry-run\&quot;: true&#x60; to perform a dry-run. | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

