/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;

public enum Status {
    OK("OK"),
    DENIED("DENIED"),
    DENIED_PERMANENT("DENIED_PERMANENT"),
    ERROR("ERROR"),
    NOINFO("NOINFO");

    private String value;

    private Status(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static Status fromValue(String value) {
        Status[] statusArray = Status.values();
        int n = statusArray.length;
        int n2 = 0;
        while (n2 < n) {
            Status b = statusArray[n2];
            if (b.value.equals(value)) {
                return b;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format(Locale.ROOT, "%s=%s", prefix, this.toString());
    }
}

