/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.api;

import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.BaseApi;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.Pair;
import ch.myelexis.server.model.Stock;
import ch.myelexis.server.model.StockEntry;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class StockServiceV1Api
extends BaseApi {
    public StockServiceV1Api() {
        super(Configuration.getDefaultApiClient());
    }

    public StockServiceV1Api(ApiClient apiClient) {
        super(apiClient);
    }

    public Stock createStock(@Nonnull Stock stock) throws ApiException {
        return this.createStock(stock, Collections.emptyMap());
    }

    public Stock createStock(@Nonnull Stock stock, Map<String, String> additionalHeaders) throws ApiException {
        Stock localVarPostBody = stock;
        if (stock == null) {
            throw new ApiException(400, "Missing the required parameter 'stock' when calling createStock");
        }
        String localVarPath = "/api/v1/services/stock";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<Stock> localVarReturnType = new TypeReference<Stock>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<StockEntry> listStockEntries(@Nonnull String stockId) throws ApiException {
        return this.listStockEntries(stockId, Collections.emptyMap());
    }

    public List<StockEntry> listStockEntries(@Nonnull String stockId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (stockId == null) {
            throw new ApiException(400, "Missing the required parameter 'stockId' when calling listStockEntries");
        }
        String localVarPath = "/api/v1/services/stock/{stockId}".replaceAll("\\{stockId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(stockId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<List<StockEntry>> localVarReturnType = new TypeReference<List<StockEntry>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Stock> listStocks() throws ApiException {
        return this.listStocks(Collections.emptyMap());
    }

    public List<Stock> listStocks(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/services/stock";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<List<Stock>> localVarReturnType = new TypeReference<List<Stock>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void outlayArticleOnStockCommissioningSystem(@Nonnull String stockId, @Nonnull String stockEntryId) throws ApiException {
        this.outlayArticleOnStockCommissioningSystem(stockId, stockEntryId, Collections.emptyMap());
    }

    public void outlayArticleOnStockCommissioningSystem(@Nonnull String stockId, @Nonnull String stockEntryId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (stockId == null) {
            throw new ApiException(400, "Missing the required parameter 'stockId' when calling outlayArticleOnStockCommissioningSystem");
        }
        if (stockEntryId == null) {
            throw new ApiException(400, "Missing the required parameter 'stockEntryId' when calling outlayArticleOnStockCommissioningSystem");
        }
        String localVarPath = "/api/v1/services/stock/{stockId}/$scs-outlay".replaceAll("\\{stockId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(stockId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("stockEntryId", stockEntryId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void startStockCommissioningSystem(@Nonnull String stockId) throws ApiException {
        this.startStockCommissioningSystem(stockId, Collections.emptyMap());
    }

    public void startStockCommissioningSystem(@Nonnull String stockId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (stockId == null) {
            throw new ApiException(400, "Missing the required parameter 'stockId' when calling startStockCommissioningSystem");
        }
        String localVarPath = "/api/v1/services/stock/{stockId}/$scs-start".replaceAll("\\{stockId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(stockId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void stopStockCommissioningSystem(@Nonnull String stockId) throws ApiException {
        this.stopStockCommissioningSystem(stockId, Collections.emptyMap());
    }

    public void stopStockCommissioningSystem(@Nonnull String stockId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (stockId == null) {
            throw new ApiException(400, "Missing the required parameter 'stockId' when calling stopStockCommissioningSystem");
        }
        String localVarPath = "/api/v1/services/stock/{stockId}/$scs-stop".replaceAll("\\{stockId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(stockId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void synchronizeStockFromStockCommissioningSystem(@Nonnull String stockId) throws ApiException {
        this.synchronizeStockFromStockCommissioningSystem(stockId, Collections.emptyMap());
    }

    public void synchronizeStockFromStockCommissioningSystem(@Nonnull String stockId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (stockId == null) {
            throw new ApiException(400, "Missing the required parameter 'stockId' when calling synchronizeStockFromStockCommissioningSystem");
        }
        String localVarPath = "/api/v1/services/stock/{stockId}/$scs-sync".replaceAll("\\{stockId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(stockId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

