/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.api;

import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.BaseApi;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.Pair;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class EntityManagementApi
extends BaseApi {
    public EntityManagementApi() {
        super(Configuration.getDefaultApiClient());
    }

    public EntityManagementApi(ApiClient apiClient) {
        super(apiClient);
    }

    public Map<String, String> getEntityExtInfo(@Nonnull String entityId, @Nonnull String entityType) throws ApiException {
        return this.getEntityExtInfo(entityId, entityType, Collections.emptyMap());
    }

    public Map<String, String> getEntityExtInfo(@Nonnull String entityId, @Nonnull String entityType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling getEntityExtInfo");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling getEntityExtInfo");
        }
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replaceAll("\\{entityId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityId))).replaceAll("\\{entityType\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityType)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<Map<String, String>> localVarReturnType = new TypeReference<Map<String, String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void removeEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key) throws ApiException {
        this.removeEntityExtInfoKeyValue(entityId, entityType, key, Collections.emptyMap());
    }

    public void removeEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling removeEntityExtInfoKeyValue");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling removeEntityExtInfoKeyValue");
        }
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replaceAll("\\{entityId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityId))).replaceAll("\\{entityType\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityType)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setMultipleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nonnull Map<String, String> requestBody) throws ApiException {
        this.setMultipleEntityExtInfoKeyValue(entityId, entityType, requestBody, Collections.emptyMap());
    }

    public void setMultipleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nonnull Map<String, String> requestBody, Map<String, String> additionalHeaders) throws ApiException {
        Map<String, String> localVarPostBody = requestBody;
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling setMultipleEntityExtInfoKeyValue");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling setMultipleEntityExtInfoKeyValue");
        }
        if (requestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'requestBody' when calling setMultipleEntityExtInfoKeyValue");
        }
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replaceAll("\\{entityId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityId))).replaceAll("\\{entityType\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityType)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setSingleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, @Nullable String value) throws ApiException {
        this.setSingleEntityExtInfoKeyValue(entityId, entityType, key, value, Collections.emptyMap());
    }

    public void setSingleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, @Nullable String value, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling setSingleEntityExtInfoKeyValue");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling setSingleEntityExtInfoKeyValue");
        }
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replaceAll("\\{entityId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityId))).replaceAll("\\{entityType\\}", this.apiClient.escapeString(this.apiClient.parameterToString(entityType)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("value", value));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

