/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.api;

import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.BaseApi;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.Pair;
import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ConfigApi
extends BaseApi {
    public ConfigApi() {
        super(Configuration.getDefaultApiClient());
    }

    public ConfigApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void deleteGlobalConfigurationValueByKey(@Nonnull String key) throws ApiException {
        this.deleteGlobalConfigurationValueByKey(key, Collections.emptyMap());
    }

    public void deleteGlobalConfigurationValueByKey(@Nonnull String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteGlobalConfigurationValueByKey");
        }
        String localVarPath = "/api/v1/user/config/global";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteUserContactConfigurationEntryByKey(@Nonnull String key) throws ApiException {
        this.deleteUserContactConfigurationEntryByKey(key, Collections.emptyMap());
    }

    public void deleteUserContactConfigurationEntryByKey(@Nonnull String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteUserContactConfigurationEntryByKey");
        }
        String localVarPath = "/api/v1/user/config/contact";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<String> findGlobalConfigurationDirectSubnodeKeysForGivenKey(@Nonnull String key) throws ApiException {
        return this.findGlobalConfigurationDirectSubnodeKeysForGivenKey(key, Collections.emptyMap());
    }

    public List<String> findGlobalConfigurationDirectSubnodeKeysForGivenKey(@Nonnull String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling findGlobalConfigurationDirectSubnodeKeysForGivenKey");
        }
        String localVarPath = "/api/v1/user/config/global-subnodekeys";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<List<String>> localVarReturnType = new TypeReference<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Map<String, String> getContactConfigurationEntries(@Nonnull String contactid) throws ApiException {
        return this.getContactConfigurationEntries(contactid, Collections.emptyMap());
    }

    public Map<String, String> getContactConfigurationEntries(@Nonnull String contactid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (contactid == null) {
            throw new ApiException(400, "Missing the required parameter 'contactid' when calling getContactConfigurationEntries");
        }
        String localVarPath = "/api/v1/management/config/contact/{contactid}".replaceAll("\\{contactid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(contactid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<Map<String, String>> localVarReturnType = new TypeReference<Map<String, String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getGlobalConfiguration(@Nullable String format) throws ApiException {
        this.getGlobalConfiguration(format, Collections.emptyMap());
    }

    public void getGlobalConfiguration(@Nullable String format, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/management/config/global";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("format", format));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public String getGlobalConfigurationValueByKey(@Nonnull String key) throws ApiException {
        return this.getGlobalConfigurationValueByKey(key, Collections.emptyMap());
    }

    public String getGlobalConfigurationValueByKey(@Nonnull String key, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getGlobalConfigurationValueByKey");
        }
        String localVarPath = "/api/v1/user/config/global";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getUserContactConfigurationAsTree(@Nullable String userContactId, @Nullable String userId) throws ApiException {
        this.getUserContactConfigurationAsTree(userContactId, userId, Collections.emptyMap());
    }

    public void getUserContactConfigurationAsTree(@Nullable String userContactId, @Nullable String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/management/config/usercontact";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("user-contact-id", userContactId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("user-id", userId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public String getUserContactConfigurationValueByKey(@Nonnull String key, @Nullable String contactId) throws ApiException {
        return this.getUserContactConfigurationValueByKey(key, contactId, Collections.emptyMap());
    }

    public String getUserContactConfigurationValueByKey(@Nonnull String key, @Nullable String contactId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getUserContactConfigurationValueByKey");
        }
        String localVarPath = "/api/v1/user/config/contact";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("contact-id", contactId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void setContactConfiguration(@Nonnull String contactid, @Nonnull Map<String, String> requestBody) throws ApiException {
        this.setContactConfiguration(contactid, requestBody, Collections.emptyMap());
    }

    public void setContactConfiguration(@Nonnull String contactid, @Nonnull Map<String, String> requestBody, Map<String, String> additionalHeaders) throws ApiException {
        Map<String, String> localVarPostBody = requestBody;
        if (contactid == null) {
            throw new ApiException(400, "Missing the required parameter 'contactid' when calling setContactConfiguration");
        }
        if (requestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'requestBody' when calling setContactConfiguration");
        }
        String localVarPath = "/api/v1/management/config/contact/{contactid}".replaceAll("\\{contactid\\}", this.apiClient.escapeString(this.apiClient.parameterToString(contactid)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setGlobalConfigurationValueByKey(@Nonnull String key, @Nonnull String body) throws ApiException {
        this.setGlobalConfigurationValueByKey(key, body, Collections.emptyMap());
    }

    public void setGlobalConfigurationValueByKey(@Nonnull String key, @Nonnull String body, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPostBody = body;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling setGlobalConfigurationValueByKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setGlobalConfigurationValueByKey");
        }
        String localVarPath = "/api/v1/user/config/global";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void setUserContactConfigurationValueByKey(@Nonnull String key, @Nonnull String body) throws ApiException {
        this.setUserContactConfigurationValueByKey(key, body, Collections.emptyMap());
    }

    public void setUserContactConfigurationValueByKey(@Nonnull String key, @Nonnull String body, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPostBody = body;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling setUserContactConfigurationValueByKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setUserContactConfigurationValueByKey");
        }
        String localVarPath = "/api/v1/user/config/contact";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("key", key));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void updateGlobalConfigByJson(@Nonnull String body) throws ApiException {
        this.updateGlobalConfigByJson(body, Collections.emptyMap());
    }

    public void updateGlobalConfigByJson(@Nonnull String body, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateGlobalConfigByJson");
        }
        String localVarPath = "/api/v1/management/config/global";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ElexisEnvironment"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

