/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ee.openapi;

import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.services.IContextService;
import ch.myelexis.server.api.UserApi;
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.Configuration;
import java.io.IOException;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class OpenApiClientProvider {
    @Reference
    IContextService contextService;
    @Reference
    IElexisEnvironmentService elexisEnvironmentService;
    @Reference
    CloseableHttpClient httpClient;

    @Activate
    public void activate() throws IOException {
        ApiClient defaultApiClient = Configuration.getDefaultApiClient();
        defaultApiClient.setHttpClient(this.httpClient);
        defaultApiClient.setBasePath("https://" + this.elexisEnvironmentService.getHostname());
        defaultApiClient.setConnectTimeout(1000);
        Configuration.setDefaultApiClient(defaultApiClient);
        UserApi userApi = new UserApi(defaultApiClient);
        FrameworkUtil.getBundle(OpenApiClientProvider.class).getBundleContext().registerService(UserApi.class, (Object)userApi, null);
    }
}

