# VirtualFilesystemServiceV1Api

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**deleteVfsUrl**](VirtualFilesystemServiceV1Api.md#deleteVfsUrl) | **DELETE** /api/v1/services/vfs/delete | Delete a file or directory from the virtual filesystem |
| [**downloadFileByVfsUrl**](VirtualFilesystemServiceV1Api.md#downloadFileByVfsUrl) | **GET** /api/v1/services/vfs/download | Download a file from the virtual filesystem |
| [**listVfsUrl**](VirtualFilesystemServiceV1Api.md#listVfsUrl) | **GET** /api/v1/services/vfs/list | List the contents of a directory |
| [**mkdirsVfsUrl**](VirtualFilesystemServiceV1Api.md#mkdirsVfsUrl) | **PUT** /api/v1/services/vfs/mkdirs | Create a directory and all intermediates |
| [**uploadFileToVfsUrl**](VirtualFilesystemServiceV1Api.md#uploadFileToVfsUrl) | **POST** /api/v1/services/vfs/upload | Upload a file to the virtual filesystem |



## deleteVfsUrl

> deleteVfsUrl(vfsUrl)

Delete a file or directory from the virtual filesystem

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.VirtualFilesystemServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        VirtualFilesystemServiceV1Api apiInstance = new VirtualFilesystemServiceV1Api(defaultClient);
        String vfsUrl = "vfsUrl_example"; // String | 
        try {
            apiInstance.deleteVfsUrl(vfsUrl);
        } catch (ApiException e) {
            System.err.println("Exception when calling VirtualFilesystemServiceV1Api#deleteVfsUrl");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **vfsUrl** | **String**|  | [optional] |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## downloadFileByVfsUrl

> File downloadFileByVfsUrl(vfsUrl)

Download a file from the virtual filesystem

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.VirtualFilesystemServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        VirtualFilesystemServiceV1Api apiInstance = new VirtualFilesystemServiceV1Api(defaultClient);
        String vfsUrl = "vfsUrl_example"; // String | 
        try {
            File result = apiInstance.downloadFileByVfsUrl(vfsUrl);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling VirtualFilesystemServiceV1Api#downloadFileByVfsUrl");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **vfsUrl** | **String**|  | [optional] |

### Return type

[**File**](File.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/octet-stream


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## listVfsUrl

> List&lt;VfsHandle&gt; listVfsUrl(vfsUrl)

List the contents of a directory

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.VirtualFilesystemServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        VirtualFilesystemServiceV1Api apiInstance = new VirtualFilesystemServiceV1Api(defaultClient);
        String vfsUrl = "vfsUrl_example"; // String | 
        try {
            List<VfsHandle> result = apiInstance.listVfsUrl(vfsUrl);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling VirtualFilesystemServiceV1Api#listVfsUrl");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **vfsUrl** | **String**|  | [optional] |

### Return type

[**List&lt;VfsHandle&gt;**](VfsHandle.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## mkdirsVfsUrl

> mkdirsVfsUrl(vfsUrl)

Create a directory and all intermediates

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.VirtualFilesystemServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        VirtualFilesystemServiceV1Api apiInstance = new VirtualFilesystemServiceV1Api(defaultClient);
        String vfsUrl = "vfsUrl_example"; // String | 
        try {
            apiInstance.mkdirsVfsUrl(vfsUrl);
        } catch (ApiException e) {
            System.err.println("Exception when calling VirtualFilesystemServiceV1Api#mkdirsVfsUrl");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **vfsUrl** | **String**|  | [optional] |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## uploadFileToVfsUrl

> uploadFileToVfsUrl(body, vfsUrl)

Upload a file to the virtual filesystem

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.VirtualFilesystemServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        VirtualFilesystemServiceV1Api apiInstance = new VirtualFilesystemServiceV1Api(defaultClient);
        File body = new File("/path/to/file"); // File | 
        String vfsUrl = "vfsUrl_example"; // String | 
        try {
            apiInstance.uploadFileToVfsUrl(body, vfsUrl);
        } catch (ApiException e) {
            System.err.println("Exception when calling VirtualFilesystemServiceV1Api#uploadFileToVfsUrl");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | **File**|  | |
| **vfsUrl** | **String**|  | [optional] |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/octet-stream
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

