# UserManagementApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createUser**](UserManagementApi.md#createUser) | **POST** /api/v1/management/user | Create a new user |
| [**deleteUser**](UserManagementApi.md#deleteUser) | **DELETE** /api/v1/management/user/{id} | Remove user from database |
| [**getUser**](UserManagementApi.md#getUser) | **GET** /api/v1/management/user/{id} | Get User |
| [**getUsers**](UserManagementApi.md#getUsers) | **GET** /api/v1/management/user | List all users |
| [**listAvailableGroups**](UserManagementApi.md#listAvailableGroups) | **GET** /api/v1/management/user/list-available-groups | List available groups |
| [**listAvailableRoles**](UserManagementApi.md#listAvailableRoles) | **GET** /api/v1/management/user/list-available-roles | List available roles |
| [**updateUser**](UserManagementApi.md#updateUser) | **PUT** /api/v1/management/user/{id} | Update an existing user |
| [**upstreamSyncToKeycloak**](UserManagementApi.md#upstreamSyncToKeycloak) | **PUT** /api/v1/management/user/sync-to-keycloak | Upstream keycloak sync user data |



## createUser

> createUser(user)

Create a new user

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;Creates a new user and, if no assocatiedContactId is provided, an associated contact in the database

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        User user = new User(); // User | 
        try {
            apiInstance.createUser(user);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#createUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **user** | [**User**](User.md)|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **412** | some precondition failed, see message |  -  |
| **201** | User successfully created |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## deleteUser

> deleteUser(id, cascadeKeycloak)

Remove user from database

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;Removes the user from the database, does not remove the associated contact

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        String id = "id_example"; // String | 
        Boolean cascadeKeycloak = false; // Boolean | Cascade delete operation to keycloak
        try {
            apiInstance.deleteUser(id, cascadeKeycloak);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#deleteUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |
| **cascadeKeycloak** | **Boolean**| Cascade delete operation to keycloak | [optional] [default to false] |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUser

> User getUser(id)

Get User

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        String id = "id_example"; // String | 
        try {
            User result = apiInstance.getUser(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#getUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

[**User**](User.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## getUsers

> List&lt;User&gt; getUsers()

List all users

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;Lists all users in the system.

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        try {
            List<User> result = apiInstance.getUsers();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#getUsers");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;User&gt;**](User.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## listAvailableGroups

> List&lt;String&gt; listAvailableGroups()

List available groups

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;The user groups a user may be a member of.

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        try {
            List<String> result = apiInstance.listAvailableGroups();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#listAvailableGroups");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**List&lt;String&gt;**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## listAvailableRoles

> List&lt;String&gt; listAvailableRoles()

List available roles

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;The access roles assignable to a user.

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        try {
            List<String> result = apiInstance.listAvailableRoles();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#listAvailableRoles");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**List&lt;String&gt;**

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## updateUser

> updateUser(id, user)

Update an existing user

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;Requires the associatedContactId to be set. Updates the user and the associated contact.

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        String id = "id_example"; // String | 
        User user = new User(); // User | 
        try {
            apiInstance.updateUser(id, user);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#updateUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |
| **user** | [**User**](User.md)|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## upstreamSyncToKeycloak

> upstreamSyncToKeycloak(username)

Upstream keycloak sync user data

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;Synchronizes the user to the Keycloak server. Creates the user if it does not exist. Updates the user if it exists.

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.UserManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        UserManagementApi apiInstance = new UserManagementApi(defaultClient);
        String username = "username_example"; // String | 
        try {
            apiInstance.upstreamSyncToKeycloak(username);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserManagementApi#upstreamSyncToKeycloak");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **username** | **String**|  | [optional] |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **412** | Some precondition failed, see message |  -  |
| **200** | Successful sync, returns keycloak user data |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

