# TaskServiceV1Api

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateTask**](TaskServiceV1Api.md#activateTask) | **PUT** /api/v1/services/task/{id}/$activate | Activate and possibly incur task |
| [**createTask**](TaskServiceV1Api.md#createTask) | **POST** /api/v1/services/task | Create a new task |
| [**deactivateTask**](TaskServiceV1Api.md#deactivateTask) | **PUT** /api/v1/services/task/{id}/$deactivate | Deactivate task |
| [**deleteTask**](TaskServiceV1Api.md#deleteTask) | **DELETE** /api/v1/services/task/{id} | Delete task |
| [**findRunnableExecutions**](TaskServiceV1Api.md#findRunnableExecutions) | **GET** /api/v1/services/runnable/{runnableId}/executions | Find all current and past executions of a runnable |
| [**findTask**](TaskServiceV1Api.md#findTask) | **GET** /api/v1/services/task/{id} | Get task and its state |
| [**findTaskExecutions**](TaskServiceV1Api.md#findTaskExecutions) | **GET** /api/v1/services/task/{id}/executions | Get all task executions ordered by create time descending (limit 25) |
| [**findTasks**](TaskServiceV1Api.md#findTasks) | **GET** /api/v1/services/task | List tasks |
| [**listRunnables**](TaskServiceV1Api.md#listRunnables) | **GET** /api/v1/services/runnable | List available runnables |
| [**refreshTask**](TaskServiceV1Api.md#refreshTask) | **PUT** /api/v1/services/task/{id}/$refresh | Refreshes the info on this task, and acts on it |
| [**triggerRunnable**](TaskServiceV1Api.md#triggerRunnable) | **POST** /api/v1/services/runnable/{runnableId}/$trigger | Trigger asynchronous execution of a runnable |
| [**triggerRunnableSync**](TaskServiceV1Api.md#triggerRunnableSync) | **POST** /api/v1/services/runnable/{runnableId}/$trigger-sync | Trigger synchronous execution of a runnable by its id |
| [**triggerTask**](TaskServiceV1Api.md#triggerTask) | **PUT** /api/v1/services/task/{id}/$trigger | Trigger task |
| [**updateTask**](TaskServiceV1Api.md#updateTask) | **PUT** /api/v1/services/task/{id} | Update task |



## activateTask

> activateTask(id)

Activate and possibly incur task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.activateTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#activateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## createTask

> Task createTask(task)

Create a new task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        Task task = new Task(); // Task | 
        try {
            Task result = apiInstance.createTask(task);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#createTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **task** | [**Task**](Task.md)|  | |

### Return type

[**Task**](Task.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## deactivateTask

> deactivateTask(id)

Deactivate task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.deactivateTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#deactivateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## deleteTask

> deleteTask(id)

Delete task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.deleteTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#deleteTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findRunnableExecutions

> List&lt;TaskResult&gt; findRunnableExecutions(runnableId)

Find all current and past executions of a runnable

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        try {
            List<TaskResult> result = apiInstance.findRunnableExecutions(runnableId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findRunnableExecutions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |

### Return type

[**List&lt;TaskResult&gt;**](TaskResult.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findTask

> Task findTask(id)

Get task and its state

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            Task result = apiInstance.findTask(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

[**Task**](Task.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findTaskExecutions

> List&lt;TaskResult&gt; findTaskExecutions(id)

Get all task executions ordered by create time descending (limit 25)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            List<TaskResult> result = apiInstance.findTaskExecutions(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTaskExecutions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

[**List&lt;TaskResult&gt;**](TaskResult.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findTasks

> List&lt;Task&gt; findTasks(system)

List tasks

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        Boolean system = false; // Boolean | 
        try {
            List<Task> result = apiInstance.findTasks(system);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTasks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **system** | **Boolean**|  | [optional] [default to false] |

### Return type

[**List&lt;Task&gt;**](Task.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## listRunnables

> List&lt;IdentifiedRunnable&gt; listRunnables()

List available runnables

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        try {
            List<IdentifiedRunnable> result = apiInstance.listRunnables();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#listRunnables");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;IdentifiedRunnable&gt;**](IdentifiedRunnable.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## refreshTask

> refreshTask(id)

Refreshes the info on this task, and acts on it

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.refreshTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#refreshTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## triggerRunnable

> Task triggerRunnable(runnableId, requestBody)

Trigger asynchronous execution of a runnable

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            Task result = apiInstance.triggerRunnable(runnableId, requestBody);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerRunnable");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type

[**Task**](Task.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## triggerRunnableSync

> TaskResult triggerRunnableSync(runnableId, requestBody)

Trigger synchronous execution of a runnable by its id

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            TaskResult result = apiInstance.triggerRunnableSync(runnableId, requestBody);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerRunnableSync");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type

[**TaskResult**](TaskResult.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## triggerTask

> TaskResult triggerTask(id)

Trigger task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            TaskResult result = apiInstance.triggerTask(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

[**TaskResult**](TaskResult.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## updateTask

> Task updateTask(id, task)

Update task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        Task task = new Task(); // Task | 
        try {
            Task result = apiInstance.updateTask(id, task);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#updateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |
| **task** | [**Task**](Task.md)|  | |

### Return type

[**Task**](Task.md)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

