# openapi-java-client

myElexis-Server API

- API version: 1.0.0-SNAPSHOT

- Build date: 2025-10-22T07:41:32.005369967+02:00[Europe/Zurich]

- Generator version: 7.16.0

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 1.8+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>openapi-java-client</artifactId>
  <version>1.0.0-SNAPSHOT</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "org.openapitools:openapi-java-client:1.0.0-SNAPSHOT"
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/openapi-java-client-1.0.0-SNAPSHOT.jar`
- `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import ch.myelexis.server.client.*;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.model.*;
import ch.myelexis.server.api.ConfigApi;

public class ConfigApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteGlobalConfigurationValueByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#deleteGlobalConfigurationValueByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigApi* | [**deleteGlobalConfigurationValueByKey**](docs/ConfigApi.md#deleteGlobalConfigurationValueByKey) | **DELETE** /api/v1/user/config/global | Delete Global Configuration Value By Key
*ConfigApi* | [**deleteUserContactConfigurationEntryByKey**](docs/ConfigApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key
*ConfigApi* | [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](docs/ConfigApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.
*ConfigApi* | [**getContactConfigurationEntries**](docs/ConfigApi.md#getContactConfigurationEntries) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries
*ConfigApi* | [**getGlobalConfiguration**](docs/ConfigApi.md#getGlobalConfiguration) | **GET** /api/v1/management/config/global | Return the global configuration tree
*ConfigApi* | [**getGlobalConfigurationValueByKey**](docs/ConfigApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key
*ConfigApi* | [**getUserContactConfigurationAsTree**](docs/ConfigApi.md#getUserContactConfigurationAsTree) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.
*ConfigApi* | [**getUserContactConfigurationValueByKey**](docs/ConfigApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key
*ConfigApi* | [**setContactConfiguration**](docs/ConfigApi.md#setContactConfiguration) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration
*ConfigApi* | [**setGlobalConfigurationValueByKey**](docs/ConfigApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key
*ConfigApi* | [**setUserContactConfigurationValueByKey**](docs/ConfigApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key
*ConfigApi* | [**updateGlobalConfigByJson**](docs/ConfigApi.md#updateGlobalConfigByJson) | **PUT** /api/v1/management/config/global | Update Global Config By Json
*EntityManagementApi* | [**getEntityExtInfo**](docs/EntityManagementApi.md#getEntityExtInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity
*EntityManagementApi* | [**removeEntityExtInfoKeyValue**](docs/EntityManagementApi.md#removeEntityExtInfoKeyValue) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo
*EntityManagementApi* | [**setMultipleEntityExtInfoKeyValue**](docs/EntityManagementApi.md#setMultipleEntityExtInfoKeyValue) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo
*EntityManagementApi* | [**setSingleEntityExtInfoKeyValue**](docs/EntityManagementApi.md#setSingleEntityExtInfoKeyValue) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo
*InstanceServiceV1Api* | [**getInstanceStatus**](docs/InstanceServiceV1Api.md#getInstanceStatus) | **GET** /api/v1/services/instance | Get Instance Status
*LegacyApi* | [**acquireOrReleaseLocks**](docs/LegacyApi.md#acquireOrReleaseLocks) | **POST** /services/elexis/lockservice/acquireOrReleaseLocks | 
*LegacyApi* | [**getLockInfo**](docs/LegacyApi.md#getLockInfo) | **GET** /services/elexis/lockservice/lockInfo | 
*LegacyApi* | [**isLocked**](docs/LegacyApi.md#isLocked) | **POST** /services/elexis/lockservice/isLocked | 
*LegacyApi* | [**postEvent**](docs/LegacyApi.md#postEvent) | **POST** /services/elexis/eventservice/postEvent | 
*ManagementApi* | [**createUser**](docs/ManagementApi.md#createUser) | **POST** /api/v1/management/user | Create a new user
*ManagementApi* | [**deleteUser**](docs/ManagementApi.md#deleteUser) | **DELETE** /api/v1/management/user/{id} | Remove user from database
*ManagementApi* | [**getContactConfigurationEntries**](docs/ManagementApi.md#getContactConfigurationEntries) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries
*ManagementApi* | [**getEntityExtInfo**](docs/ManagementApi.md#getEntityExtInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity
*ManagementApi* | [**getGlobalConfiguration**](docs/ManagementApi.md#getGlobalConfiguration) | **GET** /api/v1/management/config/global | Return the global configuration tree
*ManagementApi* | [**getUser**](docs/ManagementApi.md#getUser) | **GET** /api/v1/management/user/{id} | Get User
*ManagementApi* | [**getUserContactConfigurationAsTree**](docs/ManagementApi.md#getUserContactConfigurationAsTree) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.
*ManagementApi* | [**getUsers**](docs/ManagementApi.md#getUsers) | **GET** /api/v1/management/user | List all users
*ManagementApi* | [**listAvailableGroups**](docs/ManagementApi.md#listAvailableGroups) | **GET** /api/v1/management/user/list-available-groups | List available groups
*ManagementApi* | [**listAvailableRoles**](docs/ManagementApi.md#listAvailableRoles) | **GET** /api/v1/management/user/list-available-roles | List available roles
*ManagementApi* | [**removeEntityExtInfoKeyValue**](docs/ManagementApi.md#removeEntityExtInfoKeyValue) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo
*ManagementApi* | [**setContactConfiguration**](docs/ManagementApi.md#setContactConfiguration) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration
*ManagementApi* | [**setMultipleEntityExtInfoKeyValue**](docs/ManagementApi.md#setMultipleEntityExtInfoKeyValue) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo
*ManagementApi* | [**setSingleEntityExtInfoKeyValue**](docs/ManagementApi.md#setSingleEntityExtInfoKeyValue) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo
*ManagementApi* | [**updateGlobalConfigByJson**](docs/ManagementApi.md#updateGlobalConfigByJson) | **PUT** /api/v1/management/config/global | Update Global Config By Json
*ManagementApi* | [**updateUser**](docs/ManagementApi.md#updateUser) | **PUT** /api/v1/management/user/{id} | Update an existing user
*ManagementApi* | [**upstreamSyncToKeycloak**](docs/ManagementApi.md#upstreamSyncToKeycloak) | **PUT** /api/v1/management/user/sync-to-keycloak | Upstream keycloak sync user data
*MessageServiceV1Api* | [**getSupportedUriSchemes**](docs/MessageServiceV1Api.md#getSupportedUriSchemes) | **GET** /api/v1/services/message/schemes | Get supported URI schemes for messaging
*MessageServiceV1Api* | [**sendMessage**](docs/MessageServiceV1Api.md#sendMessage) | **POST** /api/v1/services/message | Send a message using an available transporter scheme
*TaskServiceV1Api* | [**activateTask**](docs/TaskServiceV1Api.md#activateTask) | **PUT** /api/v1/services/task/{id}/$activate | Activate and possibly incur task
*TaskServiceV1Api* | [**createTask**](docs/TaskServiceV1Api.md#createTask) | **POST** /api/v1/services/task | Create a new task
*TaskServiceV1Api* | [**deactivateTask**](docs/TaskServiceV1Api.md#deactivateTask) | **PUT** /api/v1/services/task/{id}/$deactivate | Deactivate task
*TaskServiceV1Api* | [**deleteTask**](docs/TaskServiceV1Api.md#deleteTask) | **DELETE** /api/v1/services/task/{id} | Delete task
*TaskServiceV1Api* | [**findRunnableExecutions**](docs/TaskServiceV1Api.md#findRunnableExecutions) | **GET** /api/v1/services/runnable/{runnableId}/executions | Find all current and past executions of a runnable
*TaskServiceV1Api* | [**findTask**](docs/TaskServiceV1Api.md#findTask) | **GET** /api/v1/services/task/{id} | Get task and its state
*TaskServiceV1Api* | [**findTaskExecutions**](docs/TaskServiceV1Api.md#findTaskExecutions) | **GET** /api/v1/services/task/{id}/executions | Get all task executions ordered by create time descending (limit 25)
*TaskServiceV1Api* | [**findTasks**](docs/TaskServiceV1Api.md#findTasks) | **GET** /api/v1/services/task | List tasks
*TaskServiceV1Api* | [**listRunnables**](docs/TaskServiceV1Api.md#listRunnables) | **GET** /api/v1/services/runnable | List available runnables
*TaskServiceV1Api* | [**refreshTask**](docs/TaskServiceV1Api.md#refreshTask) | **PUT** /api/v1/services/task/{id}/$refresh | Refreshes the info on this task, and acts on it
*TaskServiceV1Api* | [**triggerRunnable**](docs/TaskServiceV1Api.md#triggerRunnable) | **POST** /api/v1/services/runnable/{runnableId}/$trigger | Trigger asynchronous execution of a runnable
*TaskServiceV1Api* | [**triggerRunnableSync**](docs/TaskServiceV1Api.md#triggerRunnableSync) | **POST** /api/v1/services/runnable/{runnableId}/$trigger-sync | Trigger synchronous execution of a runnable by its id
*TaskServiceV1Api* | [**triggerTask**](docs/TaskServiceV1Api.md#triggerTask) | **PUT** /api/v1/services/task/{id}/$trigger | Trigger task
*TaskServiceV1Api* | [**updateTask**](docs/TaskServiceV1Api.md#updateTask) | **PUT** /api/v1/services/task/{id} | Update task
*UserApi* | [**deleteGlobalConfigurationValueByKey**](docs/UserApi.md#deleteGlobalConfigurationValueByKey) | **DELETE** /api/v1/user/config/global | Delete Global Configuration Value By Key
*UserApi* | [**deleteUserContactConfigurationEntryByKey**](docs/UserApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key
*UserApi* | [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](docs/UserApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.
*UserApi* | [**getExecutiveDoctorsWorkingFor**](docs/UserApi.md#getExecutiveDoctorsWorkingFor) | **GET** /api/v1/user/executive-doctors-working-for | Get executive doctors user is working for
*UserApi* | [**getGlobalConfigurationValueByKey**](docs/UserApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key
*UserApi* | [**getUserContactConfigurationValueByKey**](docs/UserApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key
*UserApi* | [**getUserInfo**](docs/UserApi.md#getUserInfo) | **GET** /api/v1/user/info | Get user information
*UserApi* | [**setGlobalConfigurationValueByKey**](docs/UserApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key
*UserApi* | [**setUserContactConfigurationValueByKey**](docs/UserApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key
*UserManagementApi* | [**createUser**](docs/UserManagementApi.md#createUser) | **POST** /api/v1/management/user | Create a new user
*UserManagementApi* | [**deleteUser**](docs/UserManagementApi.md#deleteUser) | **DELETE** /api/v1/management/user/{id} | Remove user from database
*UserManagementApi* | [**getUser**](docs/UserManagementApi.md#getUser) | **GET** /api/v1/management/user/{id} | Get User
*UserManagementApi* | [**getUsers**](docs/UserManagementApi.md#getUsers) | **GET** /api/v1/management/user | List all users
*UserManagementApi* | [**listAvailableGroups**](docs/UserManagementApi.md#listAvailableGroups) | **GET** /api/v1/management/user/list-available-groups | List available groups
*UserManagementApi* | [**listAvailableRoles**](docs/UserManagementApi.md#listAvailableRoles) | **GET** /api/v1/management/user/list-available-roles | List available roles
*UserManagementApi* | [**updateUser**](docs/UserManagementApi.md#updateUser) | **PUT** /api/v1/management/user/{id} | Update an existing user
*UserManagementApi* | [**upstreamSyncToKeycloak**](docs/UserManagementApi.md#upstreamSyncToKeycloak) | **PUT** /api/v1/management/user/sync-to-keycloak | Upstream keycloak sync user data
*VirtualFilesystemServiceV1Api* | [**deleteVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#deleteVfsUrl) | **DELETE** /api/v1/services/vfs/delete | Delete a file or directory from the virtual filesystem
*VirtualFilesystemServiceV1Api* | [**downloadFileByVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#downloadFileByVfsUrl) | **GET** /api/v1/services/vfs/download | Download a file from the virtual filesystem
*VirtualFilesystemServiceV1Api* | [**listVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#listVfsUrl) | **GET** /api/v1/services/vfs/list | List the contents of a directory
*VirtualFilesystemServiceV1Api* | [**mkdirsVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#mkdirsVfsUrl) | **PUT** /api/v1/services/vfs/mkdirs | Create a directory and all intermediates
*VirtualFilesystemServiceV1Api* | [**uploadFileToVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#uploadFileToVfsUrl) | **POST** /api/v1/services/vfs/upload | Upload a file to the virtual filesystem


## Documentation for Models

 - [ElexisEvent](docs/ElexisEvent.md)
 - [IdentifiedRunnable](docs/IdentifiedRunnable.md)
 - [InstanceStatus](docs/InstanceStatus.md)
 - [LockInfo](docs/LockInfo.md)
 - [LockRequest](docs/LockRequest.md)
 - [LockResponse](docs/LockResponse.md)
 - [Message](docs/Message.md)
 - [OwnerTaskNotification](docs/OwnerTaskNotification.md)
 - [STATE](docs/STATE.md)
 - [Status](docs/Status.md)
 - [Task](docs/Task.md)
 - [TaskResult](docs/TaskResult.md)
 - [TaskState](docs/TaskState.md)
 - [TaskTriggerType](docs/TaskTriggerType.md)
 - [Type](docs/Type.md)
 - [User](docs/User.md)
 - [VfsHandle](docs/VfsHandle.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="ElexisEnvironment"></a>
### ElexisEnvironment


- **Type**: HTTP Bearer Token authentication (JWT)

<a id="SecurityScheme"></a>
### SecurityScheme



## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author



