/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "firstName", "familyName", "email", "associatedContactId", "roles", "groups"})
public class User {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    @Nullable
    private String firstName;
    public static final String JSON_PROPERTY_FAMILY_NAME = "familyName";
    @Nullable
    private String familyName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nonnull
    private String email;
    public static final String JSON_PROPERTY_ASSOCIATED_CONTACT_ID = "associatedContactId";
    @Nullable
    private String associatedContactId;
    public static final String JSON_PROPERTY_ROLES = "roles";
    @Nullable
    private Set<String> roles = new LinkedHashSet<String>();
    public static final String JSON_PROPERTY_GROUPS = "groups";
    @Nullable
    private Set<String> groups = new LinkedHashSet<String>();

    public User id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public User firstName(@Nullable String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @JsonProperty(value="firstName", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(@Nullable String firstName) {
        this.firstName = firstName;
    }

    public User familyName(@Nullable String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Nullable
    @JsonProperty(value="familyName", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonProperty(value="familyName", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFamilyName(@Nullable String familyName) {
        this.familyName = familyName;
    }

    public User email(@Nonnull String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(@Nonnull String email) {
        this.email = email;
    }

    public User associatedContactId(@Nullable String associatedContactId) {
        this.associatedContactId = associatedContactId;
        return this;
    }

    @Nullable
    @JsonProperty(value="associatedContactId", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssociatedContactId() {
        return this.associatedContactId;
    }

    @JsonProperty(value="associatedContactId", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssociatedContactId(@Nullable String associatedContactId) {
        this.associatedContactId = associatedContactId;
    }

    public User roles(@Nullable Set<String> roles) {
        this.roles = roles;
        return this;
    }

    public User addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new LinkedHashSet<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="roles", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getRoles() {
        return this.roles;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="roles", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(@Nullable Set<String> roles) {
        this.roles = roles;
    }

    public User groups(@Nullable Set<String> groups) {
        this.groups = groups;
        return this;
    }

    public User addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new LinkedHashSet<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="groups", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getGroups() {
        return this.groups;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="groups", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(@Nullable Set<String> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.familyName, user.familyName) && Objects.equals(this.email, user.email) && Objects.equals(this.associatedContactId, user.associatedContactId) && Objects.equals(this.roles, user.roles) && Objects.equals(this.groups, user.groups);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.familyName, this.email, this.associatedContactId, this.roles, this.groups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    associatedContactId: ").append(this.toIndentedString(this.associatedContactId)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFirstName() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sfirstName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFirstName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFamilyName() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sfamilyName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFamilyName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEmail() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAssociatedContactId() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sassociatedContactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssociatedContactId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRoles() != null) {
            i = 0;
            for (String _item : this.getRoles()) {
                try {
                    joiner.add(String.format(Locale.ROOT, "%sroles%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        if (this.getGroups() != null) {
            i = 0;
            for (String _item : this.getGroups()) {
                try {
                    joiner.add(String.format(Locale.ROOT, "%sgroups%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return joiner.toString();
    }
}

