/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ee.openapi;

import ch.elexis.core.ee.openapi.ExtendedBasicHttpCacheStorage;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.services.IContextService;
import ch.myelexis.server.api.UserApi;
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.Configuration;
import java.io.IOException;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingHttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"event.topics=info/elexis/config/*", "event.topics=info/elexis/system/clear-cache"})
public class OpenApiClientProvider
implements EventHandler {
    @Reference
    IContextService contextService;
    @Reference
    IElexisEnvironmentService elexisEnvironmentService;
    private ExtendedBasicHttpCacheStorage httpCacheStorage;
    private CloseableHttpClient httpClient;

    @Activate
    public void activate() throws IOException {
        CachingHttpClientBuilder cachingHttpClientBuilder = CachingHttpClientBuilder.create();
        CacheConfig cacheConfig = CacheConfig.custom().setSharedCache(false).build();
        this.httpCacheStorage = new ExtendedBasicHttpCacheStorage(cacheConfig);
        cachingHttpClientBuilder.setCacheConfig(cacheConfig);
        cachingHttpClientBuilder.setHttpCacheStorage((HttpCacheStorage)this.httpCacheStorage);
        CloseableHttpClient httpClient = cachingHttpClientBuilder.build();
        ApiClient defaultApiClient = Configuration.getDefaultApiClient();
        defaultApiClient.setHttpClient(httpClient);
        defaultApiClient.setBasePath("https://" + this.elexisEnvironmentService.getHostname());
        defaultApiClient.setConnectTimeout(1000);
        defaultApiClient.setBearerToken(() -> {
            String accessToken = this.contextService.getTyped(AccessToken.class).map(AccessToken::getToken).orElse(null);
            if (accessToken == null) {
                LoggerFactory.getLogger(this.getClass()).error("No AccessToken");
            }
            return accessToken;
        });
        Configuration.setDefaultApiClient(defaultApiClient);
        UserApi userApi = new UserApi(defaultApiClient);
        FrameworkUtil.getBundle(OpenApiClientProvider.class).getBundleContext().registerService(UserApi.class, (Object)userApi, null);
    }

    @Deactivate
    public void deactivate() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Error closing http client", (Throwable)e);
            }
        }
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "info/elexis/config/update": 
            case "info/elexis/system/clear-cache": 
            case "info/elexis/config/delete": {
                this.httpCacheStorage.clearCache();
                break;
            }
        }
        System.out.println(event.getTopic());
    }
}

