/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ee.openapi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.cache.HttpCacheCASOperation;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.InternalCacheStorage;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ExtendedBasicHttpCacheStorage
implements HttpCacheStorage {
    private final InternalCacheStorage entries;
    private final ReentrantLock lock;

    public ExtendedBasicHttpCacheStorage(CacheConfig config) {
        this.entries = new InternalCacheStorage(config.getMaxCacheEntries(), null);
        this.lock = new ReentrantLock();
    }

    public void putEntry(String url, HttpCacheEntry entry) throws ResourceIOException {
        this.lock.lock();
        try {
            this.entries.put(url, entry);
        }
        finally {
            this.lock.unlock();
        }
    }

    public HttpCacheEntry getEntry(String url) throws ResourceIOException {
        this.lock.lock();
        try {
            HttpCacheEntry httpCacheEntry = this.entries.get(url);
            return httpCacheEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeEntry(String url) throws ResourceIOException {
        this.lock.lock();
        try {
            this.entries.remove(url);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateEntry(String url, HttpCacheCASOperation casOperation) throws ResourceIOException {
        this.lock.lock();
        try {
            HttpCacheEntry existingEntry = this.entries.get(url);
            this.entries.put(url, casOperation.execute(existingEntry));
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, HttpCacheEntry> getEntries(Collection<String> keys) throws ResourceIOException {
        Args.notNull(keys, (String)"Key");
        HashMap<String, HttpCacheEntry> resultMap = new HashMap<String, HttpCacheEntry>(keys.size());
        for (String key : keys) {
            HttpCacheEntry entry = this.getEntry(key);
            if (entry == null) continue;
            resultMap.put(key, entry);
        }
        return resultMap;
    }

    public void clearCache() {
        System.out.println("clearing http cache");
        this.entries.clear();
    }
}

