/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.Kontakt;
import ch.rgw.tools.StringTool;

public class Anschrift {
    private static final String COUNTRY = "Land";
    private static final String PLACE = "Ort";
    private static final String ZIP = "Plz";
    private static final String STREET = "Strasse";
    String Strasse;
    String Plz;
    String Ort;
    String Land;
    String[] fields = new String[]{"Strasse", "Plz", "Ort", "Land"};
    Kontakt mine;

    public Anschrift(Kontakt k) {
        this.mine = k;
        String[] values = new String[this.fields.length];
        k.get(this.fields, values);
        this.Strasse = values[0];
        this.Plz = values[1];
        this.Ort = values[2];
        this.Land = values[3];
    }

    public Anschrift() {
    }

    public String getEtikette(boolean withName, boolean multiline) {
        String sep = "\n";
        if (!multiline) {
            sep = ", ";
        }
        StringBuilder ret = new StringBuilder(100);
        if (withName) {
            ret.append(this.mine.getLabel(false)).append(sep);
        }
        if (this.Strasse != null) {
            ret.append(this.Strasse).append(sep);
        }
        if (!StringTool.isNothing((Object)this.Land)) {
            ret.append(this.Land).append(" - ");
        }
        if (this.Plz != null && this.Ort != null) {
            ret.append(this.Plz).append(" ").append(this.Ort);
        }
        if (multiline) {
            ret.append("\n");
        }
        return ret.toString();
    }

    public String getLabel() {
        return this.getEtikette(true, false);
    }

    public String getStrasse() {
        return StringTool.unNull((String)this.Strasse);
    }

    public String getPlz() {
        return StringTool.unNull((String)this.Plz);
    }

    public String getOrt() {
        return StringTool.unNull((String)this.Ort);
    }

    public String getLand() {
        return StringTool.unNull((String)this.Land);
    }

    public void setStrasse(String s) {
        this.Strasse = s;
    }

    public void setPlz(String plz) {
        this.Plz = plz != null ? (plz.length() > 6 ? plz.substring(0, 6) : plz) : "";
    }

    public void setOrt(String ort) {
        this.Ort = ort;
    }

    public void setLand(String land) {
        this.Land = land.length() > 3 ? land.substring(0, 3) : land;
    }

    public boolean write(Kontakt k) {
        return k.set(this.fields, this.Strasse, this.Plz, this.Ort, this.Land);
    }
}

