/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;

public class AllDataAccessor
implements IDataAccess {
    private IDataAccess.Element[] elements = new IDataAccess.Element[]{new IDataAccess.Element(IDataAccess.TYPE.STRING, "Konsultationen", "[Alle:-:-:Konsultationen]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Konsultationen mit Fall", "[Alle:-:-:KonsultationenFall]", null, 0)};
    ArrayList<IDataAccess.Element> elementsList = new ArrayList();

    public AllDataAccessor() {
        int i = 0;
        while (i < this.elements.length) {
            this.elementsList.add(this.elements[i]);
            ++i;
        }
    }

    @Override
    public String getName() {
        return "Spezial Alle";
    }

    @Override
    public String getDescription() {
        return "Alle Elemente eines Typs ausgeben.";
    }

    @Override
    public List<IDataAccess.Element> getList() {
        return this.elementsList;
    }

    @Override
    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        Result ret = null;
        if (descriptor.equals("Konsultationen")) {
            Patient patient = ElexisEventDispatcher.getSelectedPatient();
            ret = patient != null ? new Result(this.getAllKonsultations(patient, false)) : new Result(Result.SEVERITY.ERROR, 2, "Kein Patient selektiert.", null, false);
        } else if (descriptor.equals("KonsultationenFall")) {
            Patient patient = ElexisEventDispatcher.getSelectedPatient();
            ret = patient != null ? new Result(this.getAllKonsultations(patient, true)) : new Result(Result.SEVERITY.ERROR, 2, "Kein Patient selektiert.", null, false);
        }
        return ret;
    }

    private Object getAllKonsultations(Patient patient, boolean withFall) {
        StringBuilder sb = new StringBuilder();
        TimeTool date = new TimeTool();
        Fall[] fallArray = patient.getFaelle();
        int n = fallArray.length;
        int n2 = 0;
        while (n2 < n) {
            Fall fall = fallArray[n2];
            sb.append("* Fall " + fall.getLabel() + "\n\n");
            Konsultation[] konsultationArray = fall.getBehandlungen(true);
            int n3 = konsultationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Konsultation kons = konsultationArray[n4];
                date.set(kons.getDatum());
                sb.append("- " + date.toString(4) + " - " + kons.getMandant().getLabel(false));
                if (withFall) {
                    sb.append(" ");
                    sb.append(fall.getBezeichnung());
                }
                sb.append("\n");
                Samdas samdas = new Samdas(kons.getEintrag().getHead());
                sb.append(samdas.getRecordText());
                sb.append("\n\n");
                ++n4;
            }
            ++n2;
        }
        return sb.toString();
    }
}

