/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.ssl;

import ch.elexis.core.data.ssl.CompositeX509KeyManager;
import ch.elexis.core.data.ssl.CompositeX509TrustManager;
import ch.elexis.core.services.ISSLStoreService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class SSLStoreService
implements ISSLStoreService {
    private CompositeX509KeyManager compositeKeyManager;
    private CompositeX509TrustManager compositeTrustManager;

    @Activate
    public void activate() {
        try {
            X509KeyManager jvmKeyManager = this.getJvmKeyManager();
            X509TrustManager jvmTrustManager = this.getJvmTrustManager();
            this.compositeKeyManager = new CompositeX509KeyManager();
            KeyManager[] keyManagers = new KeyManager[]{this.compositeKeyManager};
            this.compositeKeyManager.addKeyManager(jvmKeyManager);
            this.compositeTrustManager = new CompositeX509TrustManager();
            TrustManager[] trustManagers = new TrustManager[]{this.compositeTrustManager};
            this.compositeTrustManager.addTrustManager(jvmTrustManager);
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(keyManagers, trustManagers, null);
            SSLContext.setDefault(context);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not initialize SSL context", (Throwable)e);
        }
    }

    private X509KeyManager getJvmKeyManager() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(null, null);
        return (X509KeyManager)factory.getKeyManagers()[0];
    }

    private X509TrustManager getJvmTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        return (X509TrustManager)factory.getTrustManagers()[0];
    }

    public Optional<KeyStore> loadKeyStore(InputStream keystoreInput, String keystorePass, String algorithm) {
        try {
            KeyStore keyStore = KeyStore.getInstance(algorithm);
            keyStore.load(keystoreInput, keystorePass.toCharArray());
            return Optional.of(keyStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not load key store", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<KeyStore> loadKeyStore(String keystorePath, String truststorePass, String algorithm) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream input = new FileInputStream(keystorePath);){
                return this.loadKeyStore(input, truststorePass, algorithm);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not load key store", (Throwable)e);
            return Optional.empty();
        }
    }

    public void addTrustStore(KeyStore keyStore) {
        try {
            TrustManager[] managers;
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(keyStore);
            TrustManager[] trustManagerArray = managers = factory.getTrustManagers();
            int n = managers.length;
            int n2 = 0;
            while (n2 < n) {
                TrustManager trustManager = trustManagerArray[n2];
                if (trustManager instanceof X509TrustManager) {
                    this.compositeTrustManager.addTrustManager((X509TrustManager)trustManager);
                }
                ++n2;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not add trust store", (Throwable)e);
        }
    }

    public void addKeyStore(KeyStore keyStore, String keystorePass) {
        this.compositeKeyManager.addKeyStore(keyStore, keystorePass);
    }

    public void removeKeyStore(KeyStore keyStore) {
        this.compositeKeyManager.removeKeyStore(keyStore);
    }
}

