/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.List;

public class PatientDataAccessor
implements IDataAccess {
    private static final String GESETZVERTRETER_UMLAUT = "Gesetzlicher Vertreter";
    private static final String GESETZVERTRETER_KUERZEL_UMLAUT = "Gesetzlicher Vertreter K\u00fcrzel";
    private static final String GESETZVERTRETER_ORT_UMLAUT = "Gesetzlicher Vertreter Ort";
    private static final String STAMMARZT_UMLAUT = "Stammarzt";
    private static final String STAMMARZT_KUERZEL_UMLAUT = "Stammarzt K\u00fcrzel";
    private static final String STAMMARZT_ORT_UMLAUT = "Stammarzt Ort";
    private static final String GESETZVERTRETER = "GesetzVertreter";
    private static final String GESETZVERTRETER_KUERZEL = "GesetzVertreterKuerzel";
    private static final String GESETZVERTRETER_ORT = "GesetzVertreterOrt";
    private static final String STAMMARZT = "Stammarzt";
    private static final String STAMMARZT_KUERZEL = "StammarztKuerzel";
    private static final String STAMMARZT_ORT = "StammarztOrt";
    ArrayList<IDataAccess.Element> elementsList;
    private IDataAccess.Element[] elements = new IDataAccess.Element[]{new IDataAccess.Element(IDataAccess.TYPE.STRING, "Gesetzlicher Vertreter", "[Patient:-:-:GesetzVertreter]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Gesetzlicher Vertreter K\u00fcrzel", "[Patient:-:-:GesetzVertreterKuerzel]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Gesetzlicher Vertreter Ort", "[Patient:-:-:GesetzVertreterOrt]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Stammarzt", "[Patient:-:-:Stammarzt]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Stammarzt K\u00fcrzel", "[Patient:-:-:StammarztKuerzel]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Stammarzt Ort", "[Patient:-:-:StammarztOrt]", null, 0)};

    public PatientDataAccessor() {
        this.elementsList = new ArrayList();
        int i = 0;
        while (i < this.elements.length) {
            this.elementsList.add(this.elements[i]);
            ++i;
        }
    }

    @Override
    public String getName() {
        return "Patient erweitert";
    }

    @Override
    public String getDescription() {
        return "Patient erweitert";
    }

    @Override
    public List<IDataAccess.Element> getList() {
        return this.elementsList;
    }

    @Override
    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        Result result = new Result((Object)"");
        Patient patient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        if (patient != null) {
            Kontakt familyDoctor;
            String fullName;
            String label;
            if (descriptor.equalsIgnoreCase(GESETZVERTRETER) || descriptor.equalsIgnoreCase(GESETZVERTRETER_UMLAUT)) {
                legalGuardian = this.getLegalGuardian(patient);
                result = new Result((Object)legalGuardian.getPostAnschrift(true));
            } else if (descriptor.equalsIgnoreCase(GESETZVERTRETER_KUERZEL) || descriptor.equalsIgnoreCase(GESETZVERTRETER_KUERZEL_UMLAUT)) {
                legalGuardian = this.getLegalGuardian(patient);
                label = legalGuardian.getLabel();
                fullName = label.substring(0, label.indexOf(","));
                result = new Result((Object)fullName);
            } else if (descriptor.equalsIgnoreCase(GESETZVERTRETER_ORT) || descriptor.equalsIgnoreCase(GESETZVERTRETER_ORT_UMLAUT)) {
                legalGuardian = this.getLegalGuardian(patient);
                result = new Result((Object)legalGuardian.getAnschrift().getOrt());
            }
            if (descriptor.equalsIgnoreCase("Stammarzt") || descriptor.equalsIgnoreCase("Stammarzt")) {
                familyDoctor = this.getFamilyDoctor(patient);
                if (familyDoctor != null) {
                    result = new Result((Object)familyDoctor.getPostAnschrift(true));
                }
            } else if (descriptor.equalsIgnoreCase(STAMMARZT_KUERZEL) || descriptor.equalsIgnoreCase(STAMMARZT_KUERZEL_UMLAUT)) {
                familyDoctor = this.getFamilyDoctor(patient);
                if (familyDoctor != null) {
                    label = familyDoctor.getLabel();
                    fullName = label.substring(0, label.indexOf(","));
                    result = new Result((Object)fullName);
                }
            } else if ((descriptor.equalsIgnoreCase(STAMMARZT_ORT) || descriptor.equalsIgnoreCase(STAMMARZT_ORT_UMLAUT)) && (familyDoctor = this.getFamilyDoctor(patient)) != null) {
                result = new Result((Object)familyDoctor.getAnschrift().getOrt());
            }
        }
        return result;
    }

    private Kontakt getLegalGuardian(Patient patient) {
        Kontakt legalGuardian = patient.getLegalGuardian();
        if (legalGuardian == null) {
            legalGuardian = patient;
        }
        return legalGuardian;
    }

    private Kontakt getFamilyDoctor(Patient patient) {
        return patient.getStammarzt();
    }
}

