/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.service.internal;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUser
implements IUser {
    private static Logger logger = LoggerFactory.getLogger(IUser.class);
    private String username;
    private String password;
    private IContact userContact;
    private List<IRole> roles = new ArrayList<IRole>();
    private String[] csvRows;

    public CsvUser(String[] csvRows) {
        this.csvRows = csvRows;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
    }

    public String getHashedPassword() {
        return this.password;
    }

    public void setHashedPassword(String password) {
    }

    public String getAssociatedContactId() {
        return this.userContact != null ? this.userContact.getId() : null;
    }

    public IContact getAssignedContact() {
        return this.userContact;
    }

    public void setAssignedContact(IContact contact) {
    }

    public List<IRole> getRoles() {
        return this.roles;
    }

    public List<String> getRoleIds() {
        return this.getRoles().stream().map(Identifiable::getId).toList();
    }

    public IRole addRole(IRole role) {
        return null;
    }

    public void removeRole(IRole role) {
    }

    public String getSalt() {
        return null;
    }

    public void setSalt(String salt) {
    }

    public boolean isActive() {
        return true;
    }

    public void setActive(boolean active) {
    }

    public boolean isAllowExternal() {
        return true;
    }

    public void setAllowExternal(boolean allowExternal) {
    }

    public boolean isAdministrator() {
        return false;
    }

    public void setAdministrator(boolean value) {
    }

    public String getLabel() {
        return this.getId();
    }

    public boolean isDeleted() {
        return false;
    }

    public void setDeleted(boolean value) {
    }

    public String getId() {
        return this.username;
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return true;
    }

    public IXid getXid(String domain) {
        return null;
    }

    public Long getLastupdate() {
        return null;
    }

    public IUser login(String inUsername, char[] inPassword) {
        if (this.csvRows != null) {
            String[] stringArray = this.csvRows;
            int n = this.csvRows.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                String[] splits = row.split(":");
                if (splits.length > 3 && splits[0].equals(inUsername) && Arrays.equals(splits[1].toCharArray(), inPassword)) {
                    IContact contact = CoreModelServiceHolder.get().load(splits[2], IContact.class).orElse(null);
                    if (contact != null) {
                        String[] stringArray2 = splits[3].split(",");
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String roleName = stringArray2[n4];
                            CoreModelServiceHolder.get().load(roleName, IRole.class).ifPresent(this.roles::add);
                            ++n4;
                        }
                        this.username = splits[0];
                        this.password = splits[1];
                        this.userContact = contact;
                        logger.info("Csv login successful");
                        return this;
                    }
                    logger.info("Csv contact not found for id: " + splits[3]);
                }
                ++n2;
            }
            logger.info("Csv user not found");
        }
        return null;
    }

    public boolean isInternal() {
        return false;
    }

    public void setRoles(List<IRole> roles) {
    }
}

