/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_LabResult {
    static Patient patient;
    static LabItem absoluteLabItem;
    static LabItem textLabItem;
    public static final String REFVAL = "refVal";

    @BeforeClass
    public static void prepareLabItems() {
        patient = new Patient("Mustermann", "Max", "1.1.2000", "m");
        Organisation org = new Organisation("orgname", "orgzusatz1");
        absoluteLabItem = new LabItem("kuerzel1", "testname1", (Kontakt)org, REFVAL, REFVAL, "", LabItemTyp.ABSOLUTE, "gruppe", "0");
        textLabItem = new LabItem("kuerzel2", "testname2", (Kontakt)org, REFVAL, REFVAL, "", LabItemTyp.ABSOLUTE, "gruppe", "0");
    }

    @Test
    public void testEvaluationRulesForTypeAbsolute() {
        ConfigServiceHolder.setGlobal((String)"lab/eval/tAbsolut/refValNonEqualResValMeansPath", (boolean)false);
        LabResult result = new LabResult(patient, new TimeTool(), absoluteLabItem, REFVAL, "");
        Assert.assertFalse((boolean)result.isFlag(1));
        Assert.assertFalse((boolean)result.isPathologicFlagIndetermined(null));
        Assert.assertEquals((Object)PathologicDescription.Description.PATHO_ABSOLUT, (Object)result.getPathologicDescription().getDescription());
        result = new LabResult(patient, new TimeTool(), absoluteLabItem, "neg", "");
        Assert.assertFalse((boolean)result.isFlag(1));
        Assert.assertTrue((boolean)result.isPathologicFlagIndetermined(null));
        Assert.assertEquals((Object)PathologicDescription.Description.UNKNOWN, (Object)result.getPathologicDescription().getDescription());
        ConfigServiceHolder.setGlobal((String)"lab/eval/tAbsolut/refValNonEqualResValMeansPath", (boolean)true);
        result = new LabResult(patient, new TimeTool(), absoluteLabItem, REFVAL, "");
        Assert.assertFalse((boolean)result.isFlag(1));
        Assert.assertFalse((boolean)result.isPathologicFlagIndetermined(null));
        Assert.assertEquals((Object)PathologicDescription.Description.PATHO_ABSOLUT, (Object)result.getPathologicDescription().getDescription());
        result = new LabResult(patient, new TimeTool(), absoluteLabItem, "neg", "");
        Assert.assertTrue((boolean)result.isFlag(1));
        Assert.assertFalse((boolean)result.isPathologicFlagIndetermined(null));
        Assert.assertEquals((Object)PathologicDescription.Description.PATHO_ABSOLUT, (Object)result.getPathologicDescription().getDescription());
    }

    @Test
    public void testCreateLabResultAssertLabOrder() {
        LabResult labResult = LabResult.createLabResultAndAssertLabOrder((Patient)patient, (TimeTool)new TimeTool(), (LabItem)absoluteLabItem, (String)REFVAL, (String)"", null, (String)REFVAL, null, (String)"orderId", null, null, (String)"testGroup");
        Assert.assertNotNull((Object)labResult.getId());
        Assert.assertNotNull((Object)labResult.getLabOrder());
    }
}

