/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.application.eedep;

import ch.elexis.core.application.advisors.ApplicationWorkbenchAdvisor;
import ch.elexis.core.common.DBConnection;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ee.OpenIdUser;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.httpclient.HttpClientUtil;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IElexisDataSource;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.oauth2.AccessTokenUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.eedep.EEDependentLoginDialog;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
implements IApplication {
    private Logger logger = LoggerFactory.getLogger(Application.class);
    private String eeHostname;
    @Inject
    IElexisDataSource elexisDataSource;
    @Inject
    IContextService contextService;
    @Inject
    CloseableHttpClient httpClient;

    public Object start(IApplicationContext context) {
        System.setProperty("skip.liquibase", Boolean.TRUE.toString());
        try {
            this.assertRequirements();
            context.applicationRunning();
            EEDependentLoginDialog eeDependentLoginDialog = new EEDependentLoginDialog(UiDesk.getTopShell(), this.eeHostname);
            int result = eeDependentLoginDialog.open();
            if (1 == result) {
                this.logger.info("User cancelled EEDependentLoginDialog. Exiting.");
                System.exit(0);
            }
            AccessToken accessToken = eeDependentLoginDialog.getAccessToken();
            IUser user = AccessTokenUtil.validateCreateIUser((AccessToken)accessToken);
            this.contextService.setTyped((Object)accessToken);
            DBConnection dbConnection = this.loadDBConnectionSettings(accessToken);
            IStatus status = this.elexisDataSource.setDBConnection(dbConnection);
            if (!status.isOK()) {
                this.logger.error("Error connecting to database: " + status.getMessage());
                MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"Database connection error", (String)status.getMessage());
                System.exit(-1);
            }
            this.contextService.setActiveUser(user);
            Optional associatedContact = CoreModelServiceHolder.get().load(user.getAssociatedContactId(), IContact.class);
            if (!associatedContact.isPresent()) {
                this.logger.info("Invalid associated contact for user");
                MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"Invalid associated contact", (String)("The associated contact [" + user.getAssociatedContactId() + "] can not be loaded. Exiting."));
                System.exit(-1);
            }
            ((OpenIdUser)user).setAssignedContact((IContact)associatedContact.get());
            int returnCode = PlatformUI.createAndRunWorkbench((Display)UiDesk.getDisplay(), (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            CoreHub.heart.suspend();
            LocalConfigService.flush();
            if (CoreHub.globalCfg != null) {
                CoreHub.globalCfg.flush();
            }
            if (returnCode == 1) {
                return IApplication.EXIT_RESTART;
            }
            return IApplication.EXIT_OK;
        }
        catch (Exception ex) {
            this.logger.error("Exception caught", (Throwable)ex);
            MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"Error", (String)ex.getLocalizedMessage());
            return -1;
        }
    }

    public void stop() {
    }

    private DBConnection loadDBConnectionSettings(AccessToken accessToken) {
        try {
            String body = HttpClientUtil.getOrThrowAcceptJson((CloseableHttpClient)this.httpClient, (String)("https://" + this.eeHostname + "/api/v1/ops/elexis-rcp/dbconnection.json"));
            return (DBConnection)new Gson().fromJson(body, DBConnection.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not fetch database connection settings", e);
        }
    }

    private void assertRequirements() {
        String clientSecret = System.getProperty("ee.client-secret");
        if (StringUtils.isBlank((CharSequence)clientSecret)) {
            throw new IllegalStateException("Missing property ee.client-secret");
        }
        this.eeHostname = System.getProperty("EE_HOSTNAME");
        if (StringUtils.isBlank((CharSequence)this.eeHostname)) {
            throw new IllegalStateException("Missing property EE_HOSTNAME");
        }
    }
}

