/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.application;

import ch.elexis.core.application.advisors.ApplicationWorkbenchAdvisor;
import ch.elexis.core.common.DBConnection;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.extension.ICoreOperationAdvisor;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IElexisDataSource;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.status.StatusUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.StatusDialog;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectDataSourceActivator;
import ch.rgw.io.FileTool;
import ch.rgw.io.Settings;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyApplication
implements IApplication {
    private Logger log = LoggerFactory.getLogger(LegacyApplication.class);

    public Object start(IApplicationContext context) throws InterruptedException {
        Map args;
        ICoreOperationAdvisor cod = CoreOperationAdvisorHolder.get();
        IElexisDataSource elexisDataSource = (IElexisDataSource)OsgiServiceUtil.getService(IElexisDataSource.class, (String)"(id=default)").orElseThrow();
        ObjectStatus connectionStatus = elexisDataSource.getCurrentConnectionStatus();
        if (connectionStatus != null && !connectionStatus.isOK()) {
            StatusDialog.show((IStatus)connectionStatus);
            return IApplication.EXIT_OK;
        }
        if (System.getProperty("openDBWizard") != null) {
            if (connectionStatus != null) {
                cod.openInformation("Database connection overriden", "You requested to configure the database,\nbut there is already a connection provided by a given setting.\nYou're setting won't have an effect:\n" + StatusUtil.printStatus((IStatus)connectionStatus));
            }
            cod.requestDatabaseConnectionConfiguration();
        }
        if (connectionStatus == null) {
            Optional connection = CoreUtil.getDBConnection((Settings)CoreHub.localCfg);
            if (!connection.isPresent()) {
                CoreOperationAdvisorHolder.get().requestDatabaseConnectionConfiguration();
                MessageEvent.fireInformation((String)"Datenbankverbindung ge\u00e4ndert", (String)"Bitte starten Sie Elexis erneut");
                System.exit(0);
            }
            elexisDataSource.setDBConnection((DBConnection)connection.get());
            OsgiServiceUtil.ungetService((Object)elexisDataSource);
        }
        if ((args = context.getArguments()).containsKey("--clean-all")) {
            String p = CoreUtil.getDefaultDBPath();
            FileTool.deltree((String)p);
            LocalConfigService.clear();
            LocalConfigService.flush();
        }
        this.initIdentifiers();
        PersistentObjectDataSourceActivator service = (PersistentObjectDataSourceActivator)OsgiServiceUtil.getServiceWait(PersistentObjectDataSourceActivator.class, (long)5000L).orElseThrow();
        OsgiServiceUtil.ungetService((Object)service);
        context.applicationRunning();
        if (this.isNoMandator()) {
            cod.requestInitialMandatorConfiguration();
            MessageEvent.fireInformation((String)"Neue Datenbank", (String)"Es wurde eine neue Datenbank angelegt.");
        }
        cod.performLogin((Object)new Shell(UiDesk.getDisplay()));
        if (CoreHub.getLoggedInContact() == null || !CoreHub.getLoggedInContact().isValid()) {
            this.log.warn("Exit because no valid user logged-in");
            PersistentObject.disconnect();
            System.exit(0);
        }
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)UiDesk.getDisplay(), (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            CoreHub.heart.suspend();
            LocalConfigService.flush();
            if (CoreHub.globalCfg != null) {
                CoreHub.globalCfg.flush();
            }
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Exception ex) {
            this.log.error("Exception caught", (Throwable)ex);
            ex.printStackTrace();
            Integer n = -1;
            return n;
        }
        finally {
            UiDesk.getDisplay().dispose();
        }
    }

    public void stop() {
    }

    private boolean isNoMandator() {
        ArrayList existing = new ArrayList();
        IAccessControlService accessControlService = (IAccessControlService)OsgiServiceUtil.getServiceWait(IAccessControlService.class, (long)5000L).orElseThrow();
        accessControlService.doPrivileged(() -> {
            IModelService modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").orElseThrow();
            existing.addAll(modelService.getQuery(IMandator.class).execute());
            OsgiServiceUtil.ungetService((Object)modelService);
        });
        OsgiServiceUtil.ungetService((Object)accessControlService);
        return existing.isEmpty();
    }

    protected void initIdentifiers() {
        IAccessControlService accessControlService = (IAccessControlService)OsgiServiceUtil.getServiceWait(IAccessControlService.class, (long)5000L).orElseThrow();
        accessControlService.doPrivileged(() -> {
            IConfigService configService = (IConfigService)OsgiServiceUtil.getServiceWait(IConfigService.class, (long)5000L).orElseThrow();
            if (configService.get("installation/timestamp", null) == null) {
                LocalLock localLock = new LocalLock((Object)"initInstallationTimestamp");
                if (localLock.tryLock()) {
                    configService.set("installation/timestamp", Long.toString(System.currentTimeMillis()));
                }
                localLock.unlock();
            }
            configService.setLocal("software/oid", "");
            OsgiServiceUtil.ungetService((Object)configService);
        });
        OsgiServiceUtil.ungetService((Object)accessControlService);
    }
}

