/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.application.eedep;

import ch.elexis.core.application.advisors.ApplicationWorkbenchAdvisor;
import ch.elexis.core.common.DBConnection;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IElexisDataSource;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.oauth2.AccessTokenUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.eedep.EEDependentLoginDialog;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
implements IApplication {
    private Logger logger = LoggerFactory.getLogger(Application.class);
    private String eeHostname;
    @Inject
    IElexisDataSource elexisDataSource;
    @Inject
    IContextService contextService;
    @Inject
    HttpClient httpClient;

    public Object start(IApplicationContext context) {
        System.setProperty("skip.liquibase", Boolean.TRUE.toString());
        try {
            this.assertRequirements();
            context.applicationRunning();
            EEDependentLoginDialog eeDependentLoginDialog = new EEDependentLoginDialog(UiDesk.getTopShell(), this.eeHostname);
            int result = eeDependentLoginDialog.open();
            if (1 == result) {
                this.logger.info("User cancelled EEDependentLoginDialog. Exiting.");
                System.exit(0);
            }
            AccessToken accessToken = eeDependentLoginDialog.getAccessToken();
            IUser user = AccessTokenUtil.validateCreateIUser((AccessToken)accessToken);
            this.contextService.setTyped((Object)accessToken);
            DBConnection dbConnection = this.loadDBConnectionSettings(accessToken);
            IStatus status = this.elexisDataSource.setDBConnection(dbConnection);
            if (!status.isOK()) {
                this.logger.error("Error connecting to database: " + status.getMessage());
                System.exit(-1);
            }
            this.contextService.setActiveUser(user);
            int returnCode = PlatformUI.createAndRunWorkbench((Display)UiDesk.getDisplay(), (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            CoreHub.heart.suspend();
            LocalConfigService.flush();
            if (CoreHub.globalCfg != null) {
                CoreHub.globalCfg.flush();
            }
            if (returnCode == 1) {
                return IApplication.EXIT_RESTART;
            }
            return IApplication.EXIT_OK;
        }
        catch (Exception ex) {
            this.logger.error("Exception caught", (Throwable)ex);
            MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"Error", (String)ex.getLocalizedMessage());
            return -1;
        }
    }

    public void stop() {
    }

    private DBConnection loadDBConnectionSettings(AccessToken accessToken) {
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://" + this.eeHostname + "/api/v1/ops/elexis-rcp/dbconnection.json")).header("accept", "application/json").header("Authorization", "Bearer " + accessToken.getToken()).build();
        try {
            String body = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            return (DBConnection)new Gson().fromJson(body, DBConnection.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not fetch database connection settings", e);
        }
    }

    private void assertRequirements() {
        String clientSecret = System.getProperty("ee.client-secret");
        if (StringUtils.isBlank((CharSequence)clientSecret)) {
            throw new IllegalStateException("Missing property ee.client-secret");
        }
        this.eeHostname = System.getProperty("EE_HOSTNAME");
        if (StringUtils.isBlank((CharSequence)this.eeHostname)) {
            throw new IllegalStateException("Missing property EE_HOSTNAME");
        }
    }
}

