/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefWindowHandler;
import org.cef.handler.CefWindowHandlerAdapter;
import org.cef.misc.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Widget;

public class CefBrowserSwt
extends CefBrowser_N {
    private static Method autoScaleUp;
    private long handle;
    private Composite composite;
    protected org.eclipse.swt.graphics.Rectangle currentSize;
    private CefWindowHandler windowHandler = new CefWindowHandlerAdapter(){

        @Override
        public Rectangle getRect(CefBrowser browser) {
            org.cef.misc.Point size = CefBrowserSwt.this.getChromiumSize();
            CefBrowserSwt.this.setCurrentSize();
            return new Rectangle(0, 0, size.x, size.y);
        }
    };

    static {
        try {
            Class<?> dpiClass = Class.forName("org.eclipse.swt.internal.DPIUtil");
            autoScaleUp = dpiClass.getDeclaredMethod("autoScaleUp", Point.class);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    public CefBrowserSwt(CefClient client, String url, CefRequestContext context) {
        super(client, url, context, null, null);
    }

    @Override
    public CompletableFuture<Object> createScreenshot(boolean nativeResolution) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public void createImmediately() {
        this.createBrowserIfRequired(false);
    }

    public void createImmediately(Composite composite) {
        this.composite = composite;
        this.handle = this.getHandle(composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CefBrowserSwt.this.close(true);
            }
        });
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!CefBrowserSwt.this.isClosed()) {
                    org.cef.misc.Point size = CefBrowserSwt.this.getChromiumSize();
                    CefBrowserSwt.this.setCurrentSize();
                    CefBrowserSwt.this.wasResized(size.x, size.y);
                }
            }
        });
        this.createImmediately();
    }

    public void resize() {
        if (!this.isClosed()) {
            Monitor currentMonitor;
            Monitor primaryMonitor;
            org.cef.misc.Point size = this.getChromiumSize();
            if ("win32".equals(SWT.getPlatform()) && !(primaryMonitor = Display.getDefault().getPrimaryMonitor()).equals((Object)(currentMonitor = this.composite.getShell().getMonitor()))) {
                this.wasResized(size.x + 1, size.y);
            }
            this.setCurrentSize();
            this.wasResized(size.x, size.y);
        }
    }

    private long getHandle(Composite control) {
        long hwnd = 0L;
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("view");
                field.setAccessible(true);
                Object nsview = field.get(control);
                Class<?> idClass = Class.forName("org.eclipse.swt.internal.cocoa.id");
                Field idField = idClass.getField("id");
                hwnd = (Long)idField.get(nsview);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("win32".equals(platform)) {
            try {
                Field field = Control.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = ((Number)field.get(control)).longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                Field field = Widget.class.getDeclaredField("handle");
                field.setAccessible(true);
                hwnd = ((Number)field.get(control)).longValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hwnd;
    }

    private boolean createBrowserIfRequired(boolean hasParent) {
        if (this.isClosed()) {
            return false;
        }
        long windowHandle = this.handle;
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), windowHandle, false, false, null, this.getInspectAt());
                return true;
            }
            this.createBrowser(this.getClient(), windowHandle, this.getUrl(), false, false, null, this.getRequestContext());
            return true;
        }
        return false;
    }

    @Override
    public <T> T getUIComponent() {
        return null;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, org.cef.misc.Point inspectAt) {
        return null;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return this.windowHandler;
    }

    private org.cef.misc.Point getChromiumSize() {
        org.cef.misc.Point size = new org.cef.misc.Point(this.getComposite().getSize().x, this.getComposite().getSize().y);
        if ("cocoa".equals(SWT.getPlatform())) {
            return size;
        }
        if (autoScaleUp != null) {
            try {
                Point autoScaleUpPoint = (Point)autoScaleUp.invoke(null, new Point(size.x, size.y));
                return new org.cef.misc.Point(autoScaleUpPoint.x, autoScaleUpPoint.y);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return size;
    }

    public org.eclipse.swt.graphics.Rectangle getCurrentBounds() {
        return this.currentSize;
    }

    private org.eclipse.swt.graphics.Rectangle setCurrentSize() {
        this.currentSize = this.composite.getDisplay().map((Control)this.composite, (Control)this.composite.getShell(), this.composite.getClientArea());
        return this.currentSize;
    }

    public Composite getComposite() {
        return this.composite;
    }
}

