/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.IFilter;
import ch.rgw.tools.Tree;
import java.util.Collection;
import java.util.Comparator;

public class LazyTree<T>
extends Tree<T> {
    LazyTreeListener listen;

    public LazyTree(Tree<T> p, T elem, LazyTreeListener l, Comparator<T> comp) {
        super(p, elem, comp);
        this.listen = l;
    }

    public LazyTree(Tree<T> p, T elem, LazyTreeListener l) {
        super(p, elem);
        this.listen = l;
    }

    public LazyTree(Tree<T> p, T elem, IFilter f, LazyTreeListener l) {
        super(p, elem, f);
        this.listen = l;
    }

    @Override
    public Collection<Tree<T>> getChildren() {
        this.loadChildren();
        return super.getChildren();
    }

    @Override
    public boolean hasChildren() {
        if (this.first == null) {
            return this.listen == null ? false : this.listen.hasChildren(this);
        }
        return true;
    }

    public LazyTree<T> add(T elem, LazyTreeListener l) {
        LazyTree<T> ret = new LazyTree<T>(this, elem, this.filter, l);
        return ret;
    }

    private void loadChildren() {
        if (this.first == null && this.listen != null) {
            this.listen.fetchChildren(this);
        }
    }

    @Override
    public Tree<T> getFirstChild() {
        this.loadChildren();
        return this.first;
    }

    @Override
    public synchronized Tree move(Tree newParent) {
        if (!(newParent instanceof LazyTree)) {
            this.preload();
        }
        return super.move(newParent);
    }

    public Tree preload() {
        this.loadChildren();
        Tree child = this.first;
        while (child != null) {
            if (child instanceof LazyTree) {
                ((LazyTree)child).preload();
            }
            child = child.next;
        }
        return this;
    }

    public static interface LazyTreeListener {
        public boolean fetchChildren(LazyTree<?> var1);

        public boolean hasChildren(LazyTree<?> var1);
    }
}

