/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.ExHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class IntTool {
    public static String Version() {
        return "1.1.1";
    }

    public static int toBytes(byte[] arr, int offset, long value) {
        int low = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        offset = IntTool.toBytes(arr, offset, low);
        int hi = (int)(value >> 32 & 0xFFFFFFFFFFFFFFFFL);
        offset = IntTool.toBytes(arr, offset, hi);
        return offset;
    }

    public static int toBytes(byte[] arr, int offset, int value) {
        int b1 = value & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        arr[offset++] = (byte)b1;
        arr[offset++] = (byte)b2;
        arr[offset++] = (byte)b3;
        arr[offset++] = (byte)b4;
        return offset;
    }

    public static void writeInt(int i, OutputStream out) throws IOException {
        byte[] arr = new byte[4];
        IntTool.toBytes(arr, 0, i);
        out.write(arr);
    }

    public static int readInt(InputStream in) throws IOException {
        byte[] arr = new byte[4];
        in.read(arr);
        return IntTool.fromBytesInt(arr, 0);
    }

    public static long fromBytesLong(byte[] arr, int offset) {
        int low = IntTool.fromBytesInt(arr, offset);
        long ret = (long)IntTool.fromBytesInt(arr, offset + 4) << 32;
        return ret |= (long)low;
    }

    public static int fromBytesInt(byte[] arr, int offset) {
        int b1 = IntTool.ByteToInt(arr[offset++]);
        int b2 = IntTool.ByteToInt(arr[offset++]);
        int b3 = IntTool.ByteToInt(arr[offset++]);
        int b4 = IntTool.ByteToInt(arr[offset++]);
        return b1 + (b2 << 8) + (b3 << 16) + (b4 << 24);
    }

    public static String to_prt(long val) {
        long num = val;
        int flag = 65;
        int off = 28;
        int siz = 9;
        while (num >> off == 0L) {
            off -= 4;
            --siz;
        }
        byte[] res = new byte[siz];
        int i = 1;
        while (off >= 0) {
            int nibble = (int)(num >> off & 0xFL);
            res[i] = (byte)(65 + nibble);
            ++flag;
            off -= 4;
            ++i;
        }
        res[0] = (byte)(flag - 1);
        try {
            return new String(res, "UTF-8");
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public static long from_prt(String val) {
        byte[] bytes = null;
        try {
            bytes = val.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle(e);
            return 0L;
        }
        int flag = bytes[0] - 65;
        int off = 4 * flag;
        long ret = 0L;
        int i = 1;
        while (off >= 0) {
            int nibble = bytes[i] - 65;
            ret += (long)(nibble << off);
            off -= 4;
            ++i;
        }
        return ret;
    }

    public static String envelope(long num) {
        byte[] s1;
        String s0 = IntTool.to_prt(num);
        try {
            s1 = s0.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle(e);
            return null;
        }
        int l = s1.length;
        int chk = 0;
        int i = 0;
        while (i < l) {
            if ((chk += s1[i]) > 255) {
                chk -= 255;
            }
            ++i;
        }
        String s2 = IntTool.to_prt(chk);
        String cmb = String.valueOf(s0) + s2.substring(1);
        cmb = cmb.replaceAll("(-?[^-]{4})", "$1-");
        cmb = cmb.replaceFirst("-$", "");
        cmb = cmb.toLowerCase();
        return cmb;
    }

    public static long disenvelope(String env) {
        String in = env.toUpperCase().replaceAll("-", "");
        long res = IntTool.from_prt(in);
        String cmp = IntTool.envelope(res);
        if (cmp.equals(env)) {
            return res;
        }
        return -1L;
    }

    public static int ByteToInt(byte s) {
        if (s < 0) {
            byte s1;
            byte s2 = s1 = (byte)(s & 0x7F);
            int s3 = s2 | 0x80;
            return s3;
        }
        return s;
    }

    public static String toHexString(byte x) {
        int hi = x / 16;
        int lo = x - hi;
        StringBuffer s = new StringBuffer(2);
        s.append(Character.forDigit(hi, 16));
        s.append(Character.forDigit(lo, 16));
        return s.toString();
    }

    public static float round(double val, int stel) {
        double mult = Math.pow(10.0, stel);
        long zwi = Math.round(val * mult);
        return (float)((double)zwi / 100.0);
    }

    public static double lg(double x) {
        return Math.log(x) / Math.log(10.0);
    }
}

