/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Vector;

public class ExternalSort {
    public static List<File> sortInBatch(File file, Comparator<String> cmp) throws IOException {
        Vector<File> files = new Vector<File>();
        long totalrowread = 0L;
        try (BufferedReader fbr = new BufferedReader(new FileReader(file));){
            Vector<String> tmplist = new Vector<String>();
            String line = "";
            try {
                while (line != null) {
                    tmplist = new Vector();
                    while (Runtime.getRuntime().freeMemory() > 0x200000L && (line = fbr.readLine()) != null) {
                        tmplist.add(line);
                    }
                    files.add(ExternalSort.sortAndSave(tmplist, cmp));
                    tmplist.clear();
                }
            }
            catch (EOFException oef) {
                if (tmplist.size() > 0) {
                    files.add(ExternalSort.sortAndSave(tmplist, cmp));
                    tmplist.clear();
                }
            }
        }
        return files;
    }

    public static File sortAndSave(List<String> tmplist, Comparator<String> cmp) throws IOException {
        Collections.sort(tmplist, cmp);
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile");
        newtmpfile.deleteOnExit();
        try (BufferedWriter fbw = new BufferedWriter(new FileWriter(newtmpfile));){
            for (String r : tmplist) {
                fbw.write(r);
                fbw.newLine();
            }
        }
        return newtmpfile;
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp) throws IOException {
        BinaryFileBuffer bfb;
        PriorityQueue<BinaryFileBuffer> pq = new PriorityQueue<BinaryFileBuffer>();
        for (File f : files) {
            bfb = new BinaryFileBuffer(f, cmp);
            pq.add(bfb);
        }
        int rowcounter = 0;
        try (BufferedWriter fbw = new BufferedWriter(new FileWriter(outputfile));){
            while (pq.size() > 0) {
                bfb = (BinaryFileBuffer)pq.poll();
                String r = bfb.pop();
                fbw.write(r);
                fbw.newLine();
                ++rowcounter;
                if (bfb.empty()) {
                    bfb.fbr.close();
                    bfb.originalfile.delete();
                    continue;
                }
                pq.add(bfb);
            }
        }
        return rowcounter;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("please provide input and output file names");
            return;
        }
        String inputfile = args[0];
        String outputfile = args[1];
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String r1, String r2) {
                return r1.compareTo(r2);
            }
        };
        List<File> l = ExternalSort.sortInBatch(new File(inputfile), comparator);
        ExternalSort.mergeSortedFiles(l, new File(outputfile), comparator);
    }

    public void sortFile(File in, File out, Comparator<String> cmp) throws IOException {
        List<File> l = ExternalSort.sortInBatch(in, cmp);
        ExternalSort.mergeSortedFiles(l, out, cmp);
    }

    static class BinaryFileBuffer
    implements Comparable<BinaryFileBuffer> {
        public static int BUFFERSIZE = 512;
        public BufferedReader fbr;
        private List<String> buf = new Vector<String>();
        int currentpointer = 0;
        Comparator<String> mCMP;
        public File originalfile;

        public BinaryFileBuffer(File f, Comparator<String> cmp) throws IOException {
            this.originalfile = f;
            this.mCMP = cmp;
            this.fbr = new BufferedReader(new FileReader(f));
            this.reload();
        }

        public boolean empty() {
            return this.buf.size() == 0;
        }

        private void reload() throws IOException {
            this.buf.clear();
            try {
                String line;
                while (this.buf.size() < BUFFERSIZE && (line = this.fbr.readLine()) != null) {
                    this.buf.add(line);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        public String peek() {
            if (this.empty()) {
                return null;
            }
            return this.buf.get(this.currentpointer);
        }

        public String pop() throws IOException {
            String answer = this.peek();
            ++this.currentpointer;
            if (this.currentpointer == this.buf.size()) {
                this.reload();
                this.currentpointer = 0;
            }
            return answer;
        }

        @Override
        public int compareTo(BinaryFileBuffer b) {
            return this.mCMP.compare(this.peek(), b.peek());
        }
    }
}

