/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream {
    private int buffer;
    private int pos;
    InputStream stream;

    public static final String Version() {
        return "0.3.3";
    }

    public BitInputStream(InputStream in) {
        this.stream = in;
        this.pos = 0;
    }

    @Override
    public int read() throws IOException {
        return this.pullBits(8);
    }

    public int pullBits(int bitnum) throws IOException {
        int mask = 1 << bitnum - 1;
        int ret = 0;
        while (mask != 0) {
            if (this.readBit()) {
                ret |= mask;
            }
            mask >>= 1;
        }
        return ret;
    }

    public boolean readBit() throws IOException {
        if (this.pos == 0) {
            this.buffer = this.stream.read();
            this.pos = 128;
        }
        boolean res = (this.buffer & this.pos) == this.pos;
        this.pos >>= 1;
        return res;
    }

    @Override
    public int available() throws IOException {
        if (this.stream.available() > 0) {
            return 1;
        }
        if (this.pos > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

