/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.compress.Huff;
import ch.rgw.compress.HuffmanTree;
import ch.rgw.io.BitOutputStream;
import ch.rgw.tools.IntTool;
import java.io.IOException;
import java.io.OutputStream;

public class HuffmanOutputStream
extends OutputStream {
    static final byte[] signature = new byte[]{72, 79, 83, 48, 52};
    BitOutputStream bos;
    HuffmanTree tree;
    int dyn;
    int counter;
    int[] tbl;

    public static String Version() {
        return "0.1.4";
    }

    public HuffmanOutputStream(OutputStream sup, HuffmanTree tr, int dynamic) throws IOException {
        if (tr == null) {
            this.tree = new HuffmanTree();
            this.tbl = HuffmanTree.useTable(HuffmanTree.TextDeutsch);
        } else {
            this.tree = tr;
            this.tbl = this.tree.getTable();
        }
        this.tree.build(this.tbl);
        sup.write(signature);
        IntTool.writeInt(dynamic, sup);
        this.tree.saveTable(sup);
        this.bos = new BitOutputStream(sup);
        this.dyn = dynamic;
        if (this.dyn != 0) {
            this.tbl = new int[256];
        }
    }

    @Override
    public void write(int c) throws IOException {
        Huff.writeByte(this.tree.getRootNode(), this.bos, c);
        if (this.dyn > 0) {
            int n = c;
            this.tbl[n] = this.tbl[n] + 1;
            if (++this.counter == this.dyn) {
                this.tree.build(this.tbl);
                this.tbl = new int[256];
                this.counter = 0;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.bos.flush();
    }

    @Override
    public void close() throws IOException {
        Huff.writeEOF(this.tree.getRootNode(), this.bos);
        this.bos.close();
    }
}

