/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.prescription;

import ch.elexis.core.interfaces.INumericEnum;
import java.util.HashMap;

public enum EntryType implements INumericEnum
{
    UNKNOWN(-1),
    FIXED_MEDICATION(0),
    RESERVE_MEDICATION(1),
    RECIPE(2),
    SELF_DISPENSED(3),
    SYMPTOMATIC_MEDICATION(5);

    private int numeric;
    private static HashMap<Integer, EntryType> numericMap;

    static {
        numericMap = new HashMap();
    }

    private EntryType(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    public static EntryType byNumeric(int numeric) {
        if (numericMap.isEmpty()) {
            EntryType[] entries = EntryType.values();
            int i = 0;
            while (i < entries.length) {
                numericMap.put(entries[i].numericValue(), entries[i]);
                ++i;
            }
        }
        return numericMap.getOrDefault(numeric, UNKNOWN);
    }
}

