/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.issue;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.interfaces.INumericEnum;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public enum Priority implements INumericEnum,
ILocalizedEnum
{
    LOW(0),
    MEDIUM(1),
    HIGH(2);

    private final int numeric;

    private Priority(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(Priority.class.getSimpleName()) + "_" + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public static Priority byNumericSafe(String priority) {
        if (StringUtils.isNotBlank((CharSequence)priority)) {
            try {
                int numeric = Integer.parseInt(priority);
                Priority[] priorityArray = Priority.values();
                int n = priorityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Priority prio = priorityArray[n2];
                    if (prio.numericValue() == numeric) {
                        return prio;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return MEDIUM;
    }
}

