/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.constants.Preferences;
import ch.elexis.core.model.BillingSystem;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.services.IBillingSystemService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import java.time.LocalDate;
import java.util.Arrays;

public class ICoverageBuilder
extends AbstractBuilder<ICoverage> {
    private IPatient patient;

    public ICoverageBuilder(IModelService modelService, IPatient patient, String label, String reason, String billingSystem) {
        super(modelService);
        this.patient = patient;
        this.object = modelService.create(ICoverage.class);
        ((ICoverage)this.object).setPatient(patient);
        ((ICoverage)this.object).setDescription(label);
        ((ICoverage)this.object).setReason(reason);
        ((ICoverage)this.object).setDateFrom(LocalDate.now());
        ((ICoverage)this.object).setBillingSystem(new BillingSystem(billingSystem, null));
    }

    public ICoverageBuilder(IModelService modelService, ICoverage coverage) {
        super(modelService);
        this.patient = coverage.getPatient();
        this.object = modelService.create(ICoverage.class);
        ((ICoverage)this.object).setPatient(this.patient);
        ((ICoverage)this.object).setDescription(coverage.getDescription());
        ((ICoverage)this.object).setReason(coverage.getReason());
        ((ICoverage)this.object).setDateFrom(LocalDate.now());
        ((ICoverage)this.object).setBillingSystem(coverage.getBillingSystem());
    }

    public ICoverageBuilder(IModelService modelService, IConfigService configService, IBillingSystemService billingSystemService, IPatient patient) {
        super(modelService);
        this.patient = patient;
        this.object = modelService.create(ICoverage.class);
        ((ICoverage)this.object).setPatient(patient);
        ((ICoverage)this.object).setDateFrom(LocalDate.now());
        String label = ICoverageBuilder.getDefaultCoverageLabel(configService);
        ((ICoverage)this.object).setDescription(label);
        String reason = ICoverageBuilder.getDefaultCoverageReason(configService);
        ((ICoverage)this.object).setReason(reason);
        String billingSystem = ICoverageBuilder.getDefaultCoverageLaw(configService, billingSystemService);
        ((ICoverage)this.object).setBillingSystem(new BillingSystem(billingSystem, null));
    }

    @Override
    public ICoverage buildAndSave() {
        this.modelService.save(Arrays.asList((Deleteable)((Object)this.object), this.patient));
        return (ICoverage)this.object;
    }

    public static String getDefaultCoverageLabel(IConfigService configService) {
        return configService.getActiveUserContact("fall/std_label", Preferences.USR_DEFCASELABEL_DEFAULT);
    }

    public static String getDefaultCoverageReason(IConfigService configService) {
        return configService.getActiveUserContact("fall/std_grund", Preferences.USR_DEFCASEREASON_DEFAULT);
    }

    public static String getDefaultCoverageLaw(IConfigService configService, IBillingSystemService billingSystemService) {
        return configService.getActiveUserContact("fall/std_gesetz", billingSystemService.getDefaultBillingSystem().getLaw().name());
    }

    public ICoverageBuilder guarantor(IContact guarantor) {
        ((ICoverage)this.object).setGuarantor(guarantor);
        return this;
    }

    public ICoverageBuilder costBearer(IContact costBearer) {
        ((ICoverage)this.object).setCostBearer(costBearer);
        return this;
    }

    public ICoverageBuilder billingProposalDate(LocalDate billingProposalDate) {
        ((ICoverage)this.object).setBillingProposalDate(billingProposalDate);
        return this;
    }

    public ICoverageBuilder dateFrom(LocalDate dateFrom) {
        ((ICoverage)this.object).setDateFrom(dateFrom);
        return this;
    }
}

