/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.interfaces.INumericEnum;
import java.util.ResourceBundle;

public enum InvoiceState implements INumericEnum,
ILocalizedEnum
{
    UNKNOWN(0),
    BILLED(1),
    NOT_BILLED(2),
    ONGOING(3),
    OPEN(4),
    OPEN_AND_PRINTED(5),
    DEMAND_NOTE_1(6),
    DEMAND_NOTE_1_PRINTED(7),
    DEMAND_NOTE_2(8),
    DEMAND_NOTE_2_PRINTED(9),
    DEMAND_NOTE_3(10),
    DEMAND_NOTE_3_PRINTED(11),
    IN_EXECUTION(12),
    PARTIAL_LOSS(13),
    TOTAL_LOSS(14),
    PARTIAL_PAYMENT(15),
    PAID(16),
    EXCESSIVE_PAYMENT(17),
    CANCELLED(18),
    FROM_TODAY(19),
    NOT_FROM_TODAY(20),
    NOT_FROM_YOU(21),
    DEFECTIVE(22),
    TO_PRINT(23),
    OWING(24),
    STOP_LEGAL_PROCEEDING(25),
    DEPRECIATED(26),
    REJECTED(27);

    private int state;

    private InvoiceState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public int numericValue() {
        return this.state;
    }

    public static InvoiceState[] owingStates() {
        return new InvoiceState[]{OPEN_AND_PRINTED, DEMAND_NOTE_1_PRINTED, DEMAND_NOTE_2_PRINTED, DEMAND_NOTE_3_PRINTED};
    }

    public static InvoiceState[] toPrintStates() {
        return new InvoiceState[]{OPEN, DEMAND_NOTE_1, DEMAND_NOTE_2, DEMAND_NOTE_3};
    }

    public boolean isActive() {
        if (this.state > ONGOING.getState() && this.state < PARTIAL_LOSS.getState()) {
            return true;
        }
        if (this.state == PARTIAL_PAYMENT.getState()) {
            return true;
        }
        return this.state > DEFECTIVE.getState() && this.state < DEPRECIATED.getState();
    }

    public static InvoiceState fromState(int value) {
        InvoiceState[] invoiceStateArray = InvoiceState.values();
        int n = invoiceStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            InvoiceState is = invoiceStateArray[n2];
            if (value == is.getState()) {
                return is;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(InvoiceState.class.getSimpleName()) + "_" + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public static enum REJECTCODE {
        RG_KONS_NO_BILLABLES_NOR_REVENUE,
        NO_DIAG,
        NO_MANDATOR,
        NO_CASE,
        NO_DEBITOR,
        NO_GUARANTOR,
        VALIDATION_ERROR,
        REJECTED_BY_PEER,
        SUM_MISMATCH,
        INTERNAL_ERROR;

    }
}

