/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.events;

import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.HashMap;
import java.util.Optional;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEvent {
    public static void fireError(String title, String message) {
        MessageEvent.fire(LEVEL.ERROR, title, message, null, false);
    }

    public static void fireError(String title, String message, Exception ex) {
        MessageEvent.fire(LEVEL.ERROR, title, message, ex, false);
    }

    public static void fireLoggedError(String title, String message) {
        MessageEvent.fire(LEVEL.ERROR, title, message, null, true);
    }

    public static void fireLoggedError(String title, String message, Exception ex) {
        MessageEvent.fire(LEVEL.ERROR, title, message, ex, true);
    }

    public static void fireInformation(String title, String message) {
        MessageEvent.fire(LEVEL.INFO, title, message, null, true);
    }

    private static void fire(LEVEL level, String title, String message, Exception ex, boolean log) {
        String topic;
        Logger logger = null;
        String logMsg = String.valueOf(title) + " - " + message;
        if (log) {
            logger = LoggerFactory.getLogger(MessageEvent.class);
        }
        if (level == LEVEL.ERROR) {
            topic = "info/elexis/notification/error";
            if (log && logger != null) {
                if (ex == null) {
                    logger.error(logMsg);
                } else {
                    logger.error(logMsg, (Throwable)ex);
                }
            }
        } else if (level == LEVEL.WARNING) {
            topic = "info/elexis/notification/warn";
            if (log && logger != null) {
                if (ex == null) {
                    logger.warn(logMsg);
                } else {
                    logger.warn(logMsg, (Throwable)ex);
                }
            }
        } else {
            topic = "info/elexis/notification/info";
            if (log && logger != null) {
                if (ex == null) {
                    logger.info(logMsg);
                } else {
                    logger.info(logMsg, (Throwable)ex);
                }
            }
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("title", title);
        properties.put("message", message);
        Event event = new Event(topic, properties);
        Optional<EventAdmin> eventAdmin = OsgiServiceUtil.getService(EventAdmin.class);
        if (eventAdmin.isPresent()) {
            eventAdmin.get().sendEvent(event);
        } else {
            LoggerFactory.getLogger(MessageEvent.class).error("EventAdmin not available. Message not delivered: [{} / {} / {}]", new Object[]{level, title, message});
        }
    }

    public static enum LEVEL {
        ERROR,
        WARNING,
        INFO;

    }
}

