/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.eenv;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IXid;
import ch.elexis.core.services.IModelService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class KeycloakUser
implements IUser {
    private final IModelService coreModelService;
    private final String preferredUsername;
    private final String name;
    private final String familyName;
    private final String assignedContactId;
    private final long issueTime;
    private final long expirationTime;
    private final Set<String> roles;

    public KeycloakUser(IModelService coreModelService, String preferredUsername, String name, String familyName, long issueTime, long expirationTime, String assignedContactId, Set<String> roles) {
        this.preferredUsername = preferredUsername;
        this.name = name;
        this.familyName = familyName;
        this.assignedContactId = assignedContactId;
        this.issueTime = issueTime;
        this.expirationTime = expirationTime;
        this.roles = roles;
        this.coreModelService = coreModelService;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void setDeleted(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.preferredUsername;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.name) + " " + this.familyName + " (" + this.getId() + ")";
    }

    @Override
    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return false;
    }

    @Override
    public IXid getXid(String domain) {
        return null;
    }

    @Override
    public Long getLastupdate() {
        return this.issueTime * 1000L;
    }

    @Override
    public String getUsername() {
        return this.preferredUsername;
    }

    @Override
    public void setUsername(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getHashedPassword() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHashedPassword(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSalt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSalt(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContact getAssignedContact() {
        if (this.assignedContactId != null) {
            return this.coreModelService.load(this.assignedContactId, IContact.class).orElse(null);
        }
        return null;
    }

    @Override
    public void setAssignedContact(IContact value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IRole> getRoles() {
        ArrayList<IRole> _roles = new ArrayList<IRole>();
        this.roles.forEach(rs -> this.coreModelService.load((String)rs, IRole.class).ifPresent(r -> {
            boolean bl = _roles.add((IRole)r);
        }));
        return _roles;
    }

    @Override
    public boolean isActive() {
        return this.expirationTime > System.currentTimeMillis() / 1000L;
    }

    @Override
    public void setActive(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAllowExternal() {
        return true;
    }

    @Override
    public void setAllowExternal(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAdministrator() {
        return false;
    }

    @Override
    public void setAdministrator(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRole addRole(IRole role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeRole(IRole role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IUser login(String username, char[] password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.getLabel() + " assignedContactId=" + this.assignedContactId + ", roles=" + this.roles;
    }

    @Override
    public void setRoles(List<IRole> roles) {
        throw new UnsupportedOperationException();
    }
}

