/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem;

import ch.elexis.core.data.util.SortedList;
import java.util.Comparator;
import java.util.List;

public class PlatzhalterTreeData {
    private PlatzhalterTreeData parent;
    private final SortedList<PlatzhalterTreeData> childrenList = new SortedList((Comparator)new TreeComparator());
    private final String name;
    private final String key;
    private final String description;

    public PlatzhalterTreeData(PlatzhalterTreeData _parent, String _name, String _key, String _description) {
        this.name = this.parent != null ? (_name.startsWith(this.parent.getName()) ? _name.substring(this.parent.getName().length()) : _name) : _name;
        this.key = _key;
        this.description = _description;
        this.setParent(_parent);
    }

    public PlatzhalterTreeData(String _name, String _key, String _description) {
        this(null, _name, _key, _description);
    }

    public PlatzhalterTreeData getChild(String name) {
        for (PlatzhalterTreeData ptd : this.childrenList) {
            if (!name.equals(ptd.getName())) continue;
            return ptd;
        }
        return null;
    }

    public void addChild(PlatzhalterTreeData child) {
        if (!this.childrenList.contains((Object)child)) {
            this.childrenList.add((Object)child);
        }
    }

    public void addChildren(List<PlatzhalterTreeData> children) {
        for (PlatzhalterTreeData ptd : children) {
            this.addChild(ptd);
        }
    }

    private void setParent(PlatzhalterTreeData _parent) {
        if (_parent != null) {
            this.parent = _parent;
            this.parent.addChild(this);
        }
    }

    public SortedList<PlatzhalterTreeData> getChildren() {
        return this.childrenList;
    }

    public PlatzhalterTreeData getParent() {
        return this.parent;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    class TreeComparator
    implements Comparator<PlatzhalterTreeData> {
        TreeComparator() {
        }

        @Override
        public int compare(PlatzhalterTreeData o1, PlatzhalterTreeData o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

