/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.MoneyInput;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.RnActions;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.data.Zahlung;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RnDialogs {
    public static final int ERR_STORNO = 1;
    private static final String RECHNUNG_IST_STORNIERT = "Rechnung ist storniert";

    protected boolean isResizable() {
        return true;
    }

    public static class BuchungHinzuDialog
    extends TitleAreaDialog {
        Rechnung rn;
        DatePickerCombo dp;
        Text amount;
        Text bemerkung;
        ComboViewer viewer;

        public BuchungHinzuDialog(Shell shell, Rechnung r) throws ElexisException {
            this(shell, r, false);
        }

        public BuchungHinzuDialog(Shell shell, Rechnung invoice, boolean allowCancelledInvoices) throws ElexisException {
            super(shell);
            if (invoice.getStatus() == InvoiceState.CANCELLED.numericValue() && !allowCancelledInvoices) {
                throw new ElexisException(((Object)((Object)this)).getClass(), RnDialogs.RECHNUNG_IST_STORNIERT, 1);
            }
            this.rn = invoice;
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(ret, 0).setText(Messages.Core_Date);
            this.dp = new DatePickerCombo(ret, 0);
            this.dp.setDate(new Date());
            new Label(ret, 0).setText(Messages.Core_Amount);
            this.amount = new Text(ret, 2048);
            this.amount.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(ret, 0).setText(Messages.Core_Remark);
            this.bemerkung = new Text(ret, 2050);
            this.bemerkung.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.amount.setText(this.rn.getOffenerBetrag().getAmountAsString());
            this.amount.setFocus();
            new Label(ret, 0).setText("Konto");
            this.viewer = new ComboViewer(ret, 2048);
            this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof AccountTransaction.Account) {
                        return String.valueOf(((AccountTransaction.Account)element).getNumeric()) + " - " + ((AccountTransaction.Account)element).getName();
                    }
                    return super.getText(element);
                }
            });
            ArrayList<Object> accounts = new ArrayList<Object>();
            accounts.addAll(AccountTransaction.Account.getAccounts().values());
            accounts.sort(new Comparator<AccountTransaction.Account>(){

                @Override
                public int compare(AccountTransaction.Account left, AccountTransaction.Account right) {
                    return Integer.valueOf(left.getNumeric()).compareTo(right.getNumeric());
                }
            });
            this.viewer.setInput(accounts);
            this.viewer.getCombo().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            return ret;
        }

        public void create() {
            super.create();
            this.setTitle(String.valueOf(Messages.RnDialogs_invoice) + this.rn.getNr());
            this.getShell().setText(Messages.RnDialogs_addTransaction);
            this.setMessage(Messages.RnDialogs_enterAmount);
            this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        }

        protected void okPressed() {
            Money ret = MoneyInput.getFromTextField(this.amount);
            if (ret != null) {
                AccountTransaction transaction;
                Zahlung zahlung;
                String text;
                AccountTransaction.Account account = null;
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    account = (AccountTransaction.Account)selection.getFirstElement();
                }
                if (((text = this.bemerkung.getText()) == null || text.isEmpty()) && account != null) {
                    text = account.getName();
                }
                if ((zahlung = this.rn.addZahlung(ret, text, new TimeTool(this.dp.getDate().getTime()))) != null && (transaction = zahlung.getTransaction()) != null && account != null) {
                    transaction.setAccount(account);
                }
                super.okPressed();
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RnDialogs_amountInvalid, (String)Messages.RnDialogs_invalidFormat, (IStatus)new Status(1, "ch.elexis", 1, "CurrencyFormat", null));
            }
        }

        protected boolean isResizable() {
            return true;
        }
    }

    public static class GebuehrHinzuDialog
    extends TitleAreaDialog {
        Rechnung rn;
        DatePickerCombo dp;
        Text amount;
        Text bemerkung;

        public GebuehrHinzuDialog(Shell shell, Rechnung r) throws ElexisException {
            super(shell);
            if (r.getStatus() == 18) {
                throw new ElexisException(((Object)((Object)this)).getClass(), RnDialogs.RECHNUNG_IST_STORNIERT, 1);
            }
            this.rn = r;
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            new Label(ret, 0).setText(Messages.Core_Date);
            this.dp = new DatePickerCombo(ret, 0);
            this.dp.setDate(new Date());
            new Label(ret, 0).setText(Messages.Core_Amount);
            this.amount = new Text(ret, 2048);
            this.amount.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(ret, 0).setText(Messages.Core_Remark);
            this.bemerkung = new Text(ret, 2050);
            this.bemerkung.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.amount.setFocus();
            return ret;
        }

        public void create() {
            super.create();
            this.setTitle(String.valueOf(Messages.RnDialogs_invoice) + this.rn.getNr());
            this.getShell().setText(Messages.RnDialogs_addExpense);
            this.setMessage(Messages.RnDialogs_enterAmount);
            this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        }

        protected void okPressed() {
            Money ret = MoneyInput.getFromTextField(this.amount);
            if (ret != null) {
                ret = ret.multiply(-1.0);
                this.rn.addZahlung(ret, this.bemerkung.getText(), new TimeTool(this.dp.getDate().getTime()));
                super.okPressed();
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RnDialogs_amountInvalid, (String)Messages.RnDialogs_invalidFormat, (IStatus)new Status(1, "ch.elexis", 1, "CurrencyFormat", null));
            }
        }

        protected boolean isResizable() {
            return true;
        }
    }

    public static class MultiGebuehrHinzuDialog
    extends TitleAreaDialog {
        private List<Rechnung> rechnungen;
        private List<String> rnNumbers;
        private DatePickerCombo dp;
        private Text amount;
        private Text bemerkung;
        private TableViewer tableViewer;

        public MultiGebuehrHinzuDialog(Shell shell, List<Rechnung> rechnungen) throws ElexisException {
            super(shell);
            this.rechnungen = rechnungen;
            this.rnNumbers = new ArrayList<String>();
            for (Rechnung rn : rechnungen) {
                if (rn.getStatus() == 18) {
                    throw new ElexisException(((Object)((Object)this)).getClass(), RnDialogs.RECHNUNG_IST_STORNIERT, 1);
                }
                this.rnNumbers.add(rn.getNr());
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            new Label(ret, 0).setText(Messages.Core_Date);
            this.dp = new DatePickerCombo(ret, 0);
            this.dp.setDate(new Date());
            new Label(ret, 0).setText(Messages.Core_Amount);
            this.amount = new Text(ret, 2048);
            this.amount.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(ret, 0).setText(Messages.Core_Remark);
            this.bemerkung = new Text(ret, 2050);
            this.bemerkung.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.amount.setFocus();
            this.tableViewer = new TableViewer(ret, 68096);
            GridData gd_Table = new GridData();
            gd_Table.grabExcessHorizontalSpace = true;
            gd_Table.horizontalSpan = 1;
            gd_Table.minimumHeight = 100;
            gd_Table.heightHint = 100;
            this.tableViewer.getTable().setLayoutData((Object)gd_Table);
            this.tableViewer.getTable().setHeaderVisible(true);
            this.tableViewer.getTable().setLinesVisible(false);
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            TableViewerColumn colRnNumber = new TableViewerColumn(this.tableViewer, 0);
            colRnNumber.getColumn().setWidth(200);
            colRnNumber.getColumn().setText(Messages.RnDialogs_invoiceNumber);
            colRnNumber.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
            this.tableViewer.setInput(this.rnNumbers);
            return ret;
        }

        public void create() {
            super.create();
            this.setTitle(Messages.RnDialogs_addExpenseMulti);
            this.getShell().setText(Messages.RnDialogs_addExpense);
            this.setMessage(Messages.RnDialogs_enterAmount);
            this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        }

        protected void okPressed() {
            Money ret = MoneyInput.getFromTextField(this.amount);
            if (ret != null) {
                ret = ret.multiply(-1.0);
                TimeTool ttDate = new TimeTool(this.dp.getDate().getTime());
                for (Rechnung rn : this.rechnungen) {
                    rn.addZahlung(ret, this.bemerkung.getText(), ttDate);
                }
                super.okPressed();
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RnDialogs_amountInvalid, (String)Messages.RnDialogs_invalidFormat, (IStatus)new Status(1, "ch.elexis", 1, "CurrencyFormat", null));
            }
        }

        protected boolean isResizable() {
            return true;
        }
    }

    public static class MultiStatusAendernDialog
    extends TitleAreaDialog {
        private List<Rechnung> rechnungen;
        private List<String> rnNumbers;
        private Combo cbStates;
        private TableViewer tableViewer;

        public MultiStatusAendernDialog(Shell shell, List<Rechnung> rechnungen) {
            super(shell);
            this.rechnungen = rechnungen;
            this.rnNumbers = new ArrayList<String>();
            for (Rechnung rn : rechnungen) {
                this.rnNumbers.add(rn.getNr());
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            Label lblSelectState = new Label(ret, 0);
            lblSelectState.setText(Messages.RnDialogs_pleaseNewStateForMulti);
            this.cbStates = new Combo(ret, 8);
            this.cbStates.setItems(RnStatus.getStatusTexts());
            this.cbStates.setVisibleItemCount(RnStatus.getStatusTexts().length);
            this.cbStates.select(this.rechnungen.get(0).getStatus());
            this.cbStates.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tableViewer = new TableViewer(ret, 68096);
            GridData gd_Table = new GridData();
            gd_Table.grabExcessHorizontalSpace = true;
            gd_Table.horizontalSpan = 1;
            gd_Table.minimumHeight = 150;
            gd_Table.heightHint = 150;
            this.tableViewer.getTable().setLayoutData((Object)gd_Table);
            this.tableViewer.getTable().setHeaderVisible(true);
            this.tableViewer.getTable().setLinesVisible(false);
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            TableViewerColumn colRnNumber = new TableViewerColumn(this.tableViewer, 0);
            colRnNumber.getColumn().setWidth(200);
            colRnNumber.getColumn().setText(Messages.RnDialogs_invoiceNumber);
            colRnNumber.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
            this.tableViewer.setInput(this.rnNumbers);
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.RnDialogs_modifyInvoiceState);
            this.setTitle(Messages.RnDialogs_modifyInvoiceStateMulti);
            this.setMessage(Messages.RnDialogs_warningDontChangeManually);
        }

        protected void okPressed() {
            int idx = this.cbStates.getSelectionIndex();
            if (idx != -1) {
                for (Rechnung rn : this.rechnungen) {
                    rn.setStatus(idx);
                }
            }
            super.okPressed();
        }

        protected boolean isResizable() {
            return true;
        }
    }

    public static class RnListeExportDialog
    extends TitleAreaDialog {
        ArrayList<Rechnung> rnn;
        String RnListExportDirname = CoreHub.localCfg.get("rechnung/RnListExportDirname", null);
        Text tDirName;
        private Logger log = LoggerFactory.getLogger(RnActions.class);
        private String RnListExportFileName = new SimpleDateFormat("'RnListExport-'yyyyMMddHHmmss'.csv'").format(new Date());

        public RnListeExportDialog(Shell shell, List<Rechnung> rechnungen) {
            super(shell);
            this.rnn = new ArrayList();
            for (Rechnung rn : rechnungen) {
                this.rnn.add(rn);
            }
        }

        protected Control createDialogArea(final Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new FillLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            Group cSaveCopy = new Group(ret, 0);
            cSaveCopy.setText(String.format(Messages.RnActions_exportSaveHelp, this.RnListExportFileName));
            cSaveCopy.setLayout((Layout)new GridLayout(2, false));
            Button bSelectFile = new Button((Composite)cSaveCopy, 8);
            bSelectFile.setText(Messages.RnActions_exportListDirName);
            bSelectFile.setLayoutData((Object)SWTHelper.getFillGridData(2, false, 1, false));
            bSelectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog ddlg = new DirectoryDialog(parent.getShell());
                    RnListExportDirname = ddlg.open();
                    if (RnListExportDirname == null) {
                        SWTHelper.alert(Messages.RnActions_exportListDirNameMissingCaption, Messages.RnActions_exportListDirNameMissingText);
                    } else {
                        CoreHub.localCfg.set("rechnung/RnListExportDirname", RnListExportDirname);
                        tDirName.setText(RnListExportDirname);
                    }
                }
            });
            this.tDirName = new Text((Composite)cSaveCopy, 2056);
            this.tDirName.setText(CoreHub.localCfg.get("rechnung/RnListExportDirname", ""));
            this.tDirName.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.Core_Invoice_List);
            this.setTitle(Messages.RnActions_exportListCaption);
            this.setMessage(Messages.RnActions_exportListMessage);
            this.getShell().setSize(900, 700);
            SWTHelper.center(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getShell());
        }

        protected void okPressed() {
            super.okPressed();
            this.CSVWriteTable();
        }

        public void CSVWriteTable() {
            block21: {
                String pathToSave = String.valueOf(this.RnListExportDirname) + "/" + this.RnListExportFileName;
                CSVWriter csv = null;
                int nrLines = 0;
                try {
                    try {
                        csv = new CSVWriter(new FileWriter(pathToSave));
                        String[] header = new String[]{"Aktion?", "Re.Nr", "Re.DatumRn", "Re.DatumVon", "Re.DatumBis", "Re.Garant", "Re.Total", "Re.Offen", "Re.StatusLastUpdate", "Re.Status", "Re.StatusIsActive", "Re.StatusText", "Re.StatusChanges", "Re.Rejecteds", "Re.Outputs", "Re.Payments", "Fall.AbrSystem", "Fall.Bezeichnung", "Fall.Grund", "Pat.Nr", "Pat.Name", "Pat.Vorname", "Pat.GebDat", "Pat.LztKonsDat", "Pat.Balance", "Pat.GetAccountExcess", "Pat.BillSummary.Total.", "Pat.BillSummary.Paid", "Pat.BillSummary.Open"};
                        this.log.debug("csv export started for {} with {} fields for {} invoices", new Object[]{pathToSave, header.length, this.rnn.size()});
                        csv.writeNext(header);
                        ++nrLines;
                        int i = 0;
                        while (i < this.rnn.size()) {
                            List payments;
                            String rnPayment;
                            List outputs;
                            String rnOutput;
                            List rejects;
                            String rnStatus;
                            Rechnung rn = this.rnn.get(i);
                            Fall fall = rn.getFall();
                            Patient p = fall.getPatient();
                            String[] line = new String[header.length];
                            line[0] = "";
                            line[1] = rn.getNr();
                            line[2] = rn.getDatumRn();
                            line[3] = rn.getDatumVon();
                            line[4] = rn.getDatumBis();
                            line[5] = fall.getGarant().getLabel();
                            line[6] = rn.getBetrag().toString();
                            line[7] = rn.getOffenerBetrag().toString();
                            long luTime = rn.getLastUpdate();
                            Date date = new Date(luTime);
                            SimpleDateFormat df2 = new SimpleDateFormat("dd.MM.yyyy");
                            String dateText = df2.format(date);
                            line[8] = dateText.toString();
                            int st = rn.getStatus();
                            line[9] = Integer.toString(st);
                            line[10] = RnStatus.isActive((int)st) ? "True" : "False";
                            line[11] = RnStatus.getStatusText((int)st);
                            List statuschgs = rn.getTrace("Status\u00e4nderung");
                            String a = statuschgs.toString();
                            if (a != null && a.length() > 1) {
                                a = a.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                                a = a.replaceAll(", ", "\n");
                                line[12] = a.substring(1, a.length() - 1);
                            }
                            if (rn.getStatus() == 22 && (rnStatus = (rejects = rn.getTrace("Zur\u00fcckgewiesen")).toString()) != null && rnStatus.length() > 1) {
                                rnStatus = rnStatus.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                                rnStatus = rnStatus.replaceAll(", ", "\n");
                                line[13] = rnStatus.substring(1, rnStatus.length() - 1);
                            }
                            if ((rnOutput = (outputs = rn.getTrace("Ausgegeben")).toString()) != null && rnOutput.length() > 1) {
                                rnOutput = rnOutput.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                                rnOutput = rnOutput.replaceAll(", ", "\n");
                                line[14] = rnOutput.substring(1, rnOutput.length() - 1);
                            }
                            if ((rnPayment = (payments = rn.getTrace("Zahlung")).toString()) != null && rnPayment.length() > 1) {
                                rnPayment = rnPayment.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                                rnPayment = rnPayment.replaceAll(", ", "\n");
                                line[15] = rnPayment.substring(1, rnPayment.length() - 1);
                            }
                            line[16] = fall.getAbrechnungsSystem();
                            line[17] = fall.getBezeichnung();
                            line[18] = fall.getGrund();
                            line[19] = p.getKuerzel();
                            line[20] = p.getName();
                            line[21] = p.getVorname();
                            line[22] = p.getGeburtsdatum();
                            String lkDatum = "p==null";
                            if (p != null) {
                                Konsultation lk = p.getLetzteKons(false);
                                lkDatum = lk != null ? lk.getDatum() : "lk==null";
                            }
                            line[23] = lkDatum;
                            line[24] = p.getBalance();
                            line[25] = p.getAccountExcess().toString();
                            String totalText = "";
                            String paidText = "";
                            String openText = "";
                            if (p != null) {
                                Money total = new Money(0);
                                Money paid = new Money(0);
                                List rechnungen = p.getRechnungen();
                                for (Rechnung rechnung : rechnungen) {
                                    if (rechnung.getStatus() == 18) continue;
                                    total.addMoney(rechnung.getBetrag());
                                    for (Zahlung zahlung : rechnung.getZahlungen()) {
                                        paid.addMoney(zahlung.getBetrag());
                                    }
                                }
                                Money open = new Money(total);
                                open.subtractMoney(paid);
                                totalText = total.toString();
                                paidText = paid.toString();
                                openText = open.toString();
                            }
                            line[26] = totalText;
                            line[27] = paidText;
                            line[28] = openText;
                            csv.writeNext(line);
                            ++nrLines;
                            ++i;
                        }
                        csv.close();
                        this.log.debug("{}: Wrote {} lines for {} invoices", new Object[]{pathToSave, nrLines, this.rnn.size()});
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        this.log.error("csv exporter error", (Throwable)ex);
                        SWTHelper.showError("Fehler", ex.getMessage());
                        if (csv == null) break block21;
                        try {
                            csv.close();
                        }
                        catch (IOException e) {
                            this.log.error("cannot close csv exporter", (Throwable)e);
                        }
                    }
                }
                finally {
                    if (csv != null) {
                        try {
                            csv.close();
                        }
                        catch (IOException e) {
                            this.log.error("cannot close csv exporter", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public static class StatusAendernDialog
    extends TitleAreaDialog {
        Rechnung rn;
        Combo cbStates;

        public StatusAendernDialog(Shell shell, Rechnung r) {
            super(shell);
            this.rn = r;
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.cbStates = new Combo(ret, 8);
            this.cbStates.setItems(RnStatus.getStatusTexts());
            this.cbStates.setVisibleItemCount(RnStatus.getStatusTexts().length);
            this.cbStates.select(this.rn.getStatus());
            this.cbStates.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(ret, 64).setText(Messages.RnDialogs_warningDontChangeManually);
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(String.valueOf(Messages.RnDialogs_invoiceNumber) + this.rn.getNr());
            this.setTitle(Messages.RnDialogs_modifyInvoiceState);
            this.setMessage(String.valueOf(this.rn.getFall().getPatient().getLabel()) + Messages.RnDialogs_pleaseNewState);
        }

        protected void okPressed() {
            int idx = this.cbStates.getSelectionIndex();
            if (idx != -1) {
                this.rn.setStatus(idx);
            }
            super.okPressed();
        }

        protected boolean isResizable() {
            return true;
        }
    }

    public static class StornoDialog
    extends TitleAreaDialog {
        Rechnung rn;
        Button bReactivate;
        List<Button> exporters = new ArrayList<Button>();
        private List<IRnOutputter> selectedRnOutputters;
        private List<IRnOutputter> lo;
        private boolean alwaysReactive = false;
        private List<Konsultation> konsultations;
        private boolean reopen = false;

        public StornoDialog(Shell shell, Rechnung r) {
            super(shell);
            this.rn = r;
            this.alwaysReactive = false;
        }

        public StornoDialog(Shell shell, Rechnung r, boolean alwaysReactive) {
            super(shell);
            this.rn = r;
            this.alwaysReactive = alwaysReactive;
        }

        private List<IRnOutputter> getOutputters() {
            ArrayList<IRnOutputter> outputters = new ArrayList<IRnOutputter>();
            List los = Extensions.getClasses((String)"ch.elexis.core.data.RechnungsManager", (String)"outputter");
            for (IRnOutputter rno : los) {
                if (!rno.canStorno(null) || !this.hasTrace(rno.getDescription())) continue;
                outputters.add(rno);
            }
            return outputters;
        }

        protected Control createDialogArea(Composite parent) {
            this.lo = Extensions.getClasses((String)"ch.elexis.core.data.RechnungsManager", (String)"outputter");
            if (this.lo.isEmpty()) {
                String msg2 = "Elexis has no textplugin configured for outputting bills!";
                SWTHelper.alert(msg2, msg2);
                return null;
            }
            Composite ret = new Composite(parent, 0);
            ret.setLayout((Layout)new GridLayout());
            Label lbLocal = new Label(ret, 0);
            lbLocal.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            lbLocal.setText(Messages.RnDialogs_stornoOnlyLocal);
            for (IRnOutputter rno : this.lo) {
                if (!rno.canStorno(null) || !this.hasTrace(rno.getDescription())) continue;
                Button cbStorno = new Button(ret, 32);
                cbStorno.setData((Object)rno);
                cbStorno.setText(rno.getDescription());
                cbStorno.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                cbStorno.setSelection(true);
                this.exporters.add(cbStorno);
            }
            if (this.exporters.size() > 0) {
                lbLocal.setText(Messages.RnDialogs_stornoPropagate);
            }
            new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, false));
            this.bReactivate = new Button(ret, 32);
            this.bReactivate.setText(Messages.RnDialogs_reactivateConsultations);
            this.bReactivate.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.bReactivate.setSelection(true);
            if (this.alwaysReactive) {
                this.bReactivate.setVisible(false);
            }
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            return ret;
        }

        private boolean hasTrace(String msg2) {
            List msgs = this.rn.getTrace("Ausgegeben");
            for (String m : msgs) {
                if (m.indexOf(msg2) <= -1) continue;
                return true;
            }
            return false;
        }

        public void create() {
            super.create();
            this.getShell().setText(String.valueOf(Messages.RnDialogs_invoice) + this.rn.getNr());
            this.setTitle(Messages.RnDialogs_reallyCancel);
        }

        public boolean getReopen() {
            return this.reopen;
        }

        public List<IRnOutputter> getExporters() {
            if (this.selectedRnOutputters == null) {
                this.selectedRnOutputters = new ArrayList<IRnOutputter>();
                for (Button exporter : this.exporters) {
                    if (!exporter.getSelection() || (IRnOutputter)exporter.getData() == null) continue;
                    this.selectedRnOutputters.add((IRnOutputter)exporter.getData());
                }
            }
            return this.selectedRnOutputters;
        }

        protected void okPressed() {
            this.reopen = this.bReactivate.getSelection() || this.alwaysReactive;
            this.konsultations = this.rn.stornoBill(this.reopen);
            for (IRnOutputter iro : this.getExporters()) {
                iro.doOutput(IRnOutputter.TYPE.STORNO, Arrays.asList(this.rn), new Properties());
            }
            super.okPressed();
        }

        public List<Konsultation> getKonsultations() {
            return this.konsultations;
        }

        public int open() {
            if (this.rn != null && (Rechnung.isStorno((Rechnung)this.rn) || Rechnung.hasStornoBeforeDate((Rechnung)this.rn, (TimeTool)new TimeTool()))) {
                SWTHelper.alert(Messages.RnActions_stornoAction, Messages.RnActions_stornoActionNotPossibleText);
                return 1;
            }
            return super.open();
        }

        public int openDialog() {
            List<IRnOutputter> rnOutputters = this.getOutputters();
            if (rnOutputters != null && rnOutputters.isEmpty()) {
                super.setBlockOnOpen(false);
                super.open();
                this.okPressed();
                return this.getReturnCode();
            }
            return super.open();
        }

        protected boolean isResizable() {
            return true;
        }
    }
}

