/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.documents.DocumentStore;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IInvoiceBilled;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.e4.controls.IIdentifiableModifiableListComposite;
import ch.elexis.core.ui.e4.dialog.GenericSelectionDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import ch.elexis.core.ui.views.contribution.ViewContributionHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.RnDialogs;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class RechnungsBlatt
extends Composite
implements IActivationListener {
    private static final String KEY_RECHNUNGSBLATT = "RechnungsBlatt/";
    IViewSite site;
    IIdentifiableModifiableListComposite<IDocument> attachments;
    ListViewer buchungen;
    org.eclipse.swt.widgets.List lbJournal;
    org.eclipse.swt.widgets.List lbOutputs;
    Rechnung actRn;
    ScrolledForm form;
    FormToolkit tk = UiDesk.getToolkit();
    Text tRejects;
    Text tBemerkungen;
    Text tInternalRemarks;
    Label rnAdressat;
    ListViewer konsultationenViewer;
    ListViewer stornoViewer;
    private final ExpandableComposite ecAttachments;
    private final ExpandableComposite ecBuchungen;
    private final ExpandableComposite ecBemerkungen;
    private final ExpandableComposite ecInternalRemarks;
    private final ExpandableComposite ecStatus;
    private final ExpandableComposite ecFehler;
    private final ExpandableComposite ecAusgaben;
    private final ExpandableComposite ecKons;
    private final ExpandableComposite ecStorno;
    private final List<IViewContribution> detailComposites = Extensions.getClasses((String)"ch.elexis.core.ui.ViewContribution", (String)"class", (String)"viewId", (String)"ch.elexis.RechnungsDetailView");
    private static LabeledInputField.IContentProvider openAmountContentProvider = new LabeledInputField.IContentProvider(){

        @Override
        public void displayContent(Object po, LabeledInputField.InputData ltf) {
            Rechnung invoice = (Rechnung)po;
            Money openAmount = invoice.getOffenerBetrag();
            ltf.setText(openAmount.getAmountAsString());
            if (InvoiceState.CANCELLED.numericValue() == invoice.getStatus()) {
                ltf.setLabel(Messages.RechnungsBlatt_compensateAmount);
            } else {
                ltf.setLabel(Messages.Invoice_Amount_Unpaid);
            }
        }

        @Override
        public void reloadContent(Object po, LabeledInputField.InputData ltf) {
            Rechnung invoice = (Rechnung)po;
            if (InvoiceState.CANCELLED.numericValue() == invoice.getStatus()) {
                Money openAmount = invoice.getOffenerBetrag();
                if (openAmount.isZero()) {
                    return;
                }
                if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_BILLMODIFY)) {
                    MessageDialog.openError((Shell)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Insufficient rights", (String)"You are not authorized to perform this action");
                    return;
                }
            }
            try {
                RnDialogs.BuchungHinzuDialog comp = new RnDialogs.BuchungHinzuDialog(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), invoice, true);
                comp.open();
                ElexisEventDispatcher.update((PersistentObject)invoice);
            }
            catch (ElexisException e) {
                SWTHelper.showError("Buchung kann nicht hinzugef\u00fcgt werden", e.getLocalizedMessage());
            }
        }
    };
    private static final LabeledInputField.InputData[] rndata = new LabeledInputField.InputData[]{new LabeledInputField.InputData(Messages.RechnungsBlatt_billNumber, "RnNummer", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_billDate, "RnDatum", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.Core_Invoicestate, "RnStatus", new LabeledInputField.IContentProvider(){

        @Override
        public void displayContent(Object po, LabeledInputField.InputData ltf) {
            Rechnung r = (Rechnung)po;
            ltf.setText(RnStatus.getStatusText((int)r.getStatus()));
        }

        @Override
        public void reloadContent(Object po, LabeledInputField.InputData ltf) {
            if (new RnDialogs.StatusAendernDialog(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (Rechnung)po).open() == 0) {
                ElexisEventDispatcher.update((PersistentObject)((PersistentObject)po));
            }
        }
    }), new LabeledInputField.InputData(Messages.RechnungsBlatt_treatmentsFrom, "RnDatumVon", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_treatmentsUntil, "RnDatumBis", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_amountTotal, "Betragx100", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(Messages.Invoice_Amount_Unpaid, "Betragx100", openAmountContentProvider)};
    private LabeledInputField.AutoForm rnform;
    private final ElexisEventListenerImpl eeli_rn = new ElexisUiEventListenerImpl(Rechnung.class, 55){

        @Override
        public void runInUi(ElexisEvent ev) {
            switch (ev.getType()) {
                case 4: {
                    RechnungsBlatt.this.doSelect((Rechnung)ev.getObject());
                    break;
                }
                case 32: {
                    RechnungsBlatt.this.doSelect(null);
                    break;
                }
                case 2: {
                    if (RechnungsBlatt.this.actRn == null || !RechnungsBlatt.this.actRn.getId().equals(ev.getObject().getId())) break;
                    RechnungsBlatt.this.doSelect(null);
                    break;
                }
                case 16: {
                    RechnungsBlatt.this.doSelect((Rechnung)ev.getObject());
                }
            }
        }
    };
    private final ElexisEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        @Override
        public void runInUi(ElexisEvent ev) {
            RechnungsBlatt.this.display();
        }
    };
    private final ElexisEventListenerImpl eeli_patient = new ElexisUiEventListenerImpl(Patient.class, 48){

        @Override
        public void runInUi(ElexisEvent ev) {
            Patient pat = (Patient)ev.getObject();
            switch (ev.getType()) {
                case 32: {
                    RechnungsBlatt.this.doSelect(null);
                    break;
                }
                case 16: {
                    Patient patient;
                    Fall fall;
                    if (RechnungsBlatt.this.actRn == null || !(fall = RechnungsBlatt.this.actRn.getFall()).exists() || Objects.equals(pat, patient = fall.getPatient())) break;
                    RechnungsBlatt.this.doSelect(null);
                }
            }
        }
    };

    public RechnungsBlatt(Composite parent, IViewSite site) {
        super(parent, 0);
        this.site = site;
        this.setLayout((Layout)new GridLayout());
        this.form = this.tk.createScrolledForm((Composite)this);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.rnform = new LabeledInputField.AutoForm(body, rndata, 2, 3);
        LabeledInputField.InputData[] inputDataArray = rndata;
        int n = rndata.length;
        int n2 = 0;
        while (n2 < n) {
            LabeledInputField.InputData li = inputDataArray[n2];
            li.setEditable(false);
            ++n2;
        }
        this.rnform.setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
        this.rnAdressat = new Label(body, 0);
        this.rnAdressat.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        ExpansionAdapter ecExpansionListener = new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                ExpandableComposite src = (ExpandableComposite)e.getSource();
                RechnungsBlatt.this.saveExpandedState(RechnungsBlatt.KEY_RECHNUNGSBLATT + src.getText(), e.getState());
            }
        };
        this.ecAttachments = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_attachments);
        this.ecAttachments.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.attachments = new IIdentifiableModifiableListComposite((Composite)this.ecAttachments, this.getStyle());
        GridData gd = SWTHelper.setGridDataHeight(this.attachments.getStructuredViewer().getControl(), 4, true);
        gd.widthHint = 300;
        this.attachments.getStructuredViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Rechnung actRn = (Rechnung)inputElement;
                if (actRn != null) {
                    IInvoice invoice = actRn.toIInvoice();
                    return invoice.getAttachments().toArray(new IDocument[0]);
                }
                return null;
            }
        });
        this.attachments.setAddElementHandler(() -> {
            if (this.actRn != null) {
                IPatient patient = this.actRn.getFall().getPatient().toIPatient();
                DocumentStore documentStore = OsgiServiceUtil.getService(DocumentStore.class).orElse(null);
                if (documentStore != null) {
                    List documents = documentStore.getDocuments(patient.getId(), null, null, null);
                    List pdfDocuments = documents.stream().filter(doc -> doc.getMimeType().endsWith("pdf")).collect(Collectors.toList());
                    GenericSelectionDialog gsd = new GenericSelectionDialog(this.getShell(), pdfDocuments, "Dokument w\u00e4hlen", "Nur PDF k\u00f6nnen angeh\u00e4ngt werden");
                    int result = gsd.open();
                    if (result == 0) {
                        IInvoice invoice = this.actRn.toIInvoice();
                        IStructuredSelection selection = gsd.getSelection();
                        if (!selection.isEmpty()) {
                            selection.forEach(obj -> invoice.addAttachment((IDocument)obj));
                            CoreModelServiceHolder.get().save((Identifiable)invoice);
                        }
                    }
                }
            }
        });
        this.attachments.setRemoveElementHandler(element -> {
            if (this.actRn != null) {
                IInvoice invoice = this.actRn.toIInvoice();
                invoice.removeAttachment(element);
                CoreModelServiceHolder.get().save((Identifiable)invoice);
            }
        });
        this.tk.adapt(this.attachments, true, true);
        this.ecAttachments.setClient(this.attachments);
        this.attachments.getStructuredViewer().setInput(null);
        this.ecBuchungen = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_bookings);
        this.ecBuchungen.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.buchungen = new ListViewer((Composite)this.ecBuchungen, 2560);
        SWTHelper.setGridDataHeight(this.buchungen.getControl(), 4, true);
        this.buchungen.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Rechnung actRn = (Rechnung)inputElement;
                if (actRn == null) {
                    return new String[]{Messages.RechnungsBlatt_noBillSelected};
                }
                List lz = actRn.getZahlungen();
                return lz.toArray();
            }
        });
        this.tk.adapt(this.buchungen.getControl(), true, true);
        this.ecBuchungen.setClient(this.buchungen.getControl());
        this.buchungen.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                return this.getText(element);
            }

            @Override
            public String getText(Object element) {
                if (element instanceof Zahlung) {
                    Zahlung zahlung = (Zahlung)element;
                    StringBuilder sb = new StringBuilder();
                    sb.append(zahlung.getLabel());
                    String bemerkung = zahlung.getBemerkung();
                    if (!StringTool.isNothing((Object)bemerkung)) {
                        sb.append(" (");
                        sb.append(bemerkung);
                        sb.append(")");
                    }
                    return sb.toString();
                }
                return element.toString();
            }
        });
        this.buchungen.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty()) {
                    Zahlung zahlung = (Zahlung)((StructuredSelection)selection).getFirstElement();
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ICommandService cmdService = (ICommandService)window.getService(ICommandService.class);
                    Command cmd = cmdService.getCommand("ch.elexis.ebanking_ch.command.openESRWithInvoiceId");
                    if (cmd != null) {
                        try {
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("ch.elexis.ebanking_ch.command.openESR.InvoiceId", zahlung.getRechnung().getId());
                            param.put("ch.elexis.ebanking_ch.command.openESR.PaymentDate", new TimeTool(zahlung.getDatum()).toString(9));
                            ParameterizedCommand pc = ParameterizedCommand.generateCommand((Command)cmd, param);
                            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                            handlerService.executeCommand(pc, null);
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            LoggerFactory.getLogger(this.getClass()).error("Error executing open esr command", e);
                        }
                    } else {
                        LoggerFactory.getLogger(this.getClass()).warn("No open esr command found, ebanking not installed");
                    }
                }
            }
        });
        this.buchungen.setInput(null);
        this.ecBemerkungen = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_remarks);
        this.ecBemerkungen.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.tBemerkungen = SWTHelper.createText(this.tk, (Composite)this.ecBemerkungen, 5, 2048);
        this.tBemerkungen.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (RechnungsBlatt.this.actRn != null) {
                    RechnungsBlatt.this.actRn.setBemerkung(RechnungsBlatt.this.tBemerkungen.getText());
                }
            }
        });
        this.ecBemerkungen.setClient((Control)this.tBemerkungen);
        this.ecInternalRemarks = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_internalRemarks);
        this.ecInternalRemarks.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.tInternalRemarks = SWTHelper.createText(this.tk, (Composite)this.ecInternalRemarks, 5, 2048);
        this.tInternalRemarks.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (RechnungsBlatt.this.actRn != null) {
                    RechnungsBlatt.this.actRn.setInternalRemarks(RechnungsBlatt.this.tInternalRemarks.getText());
                }
            }
        });
        this.ecInternalRemarks.setClient((Control)this.tInternalRemarks);
        this.ecStatus = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_sateChangements);
        this.ecStatus.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.lbJournal = new org.eclipse.swt.widgets.List((Composite)this.ecStatus, 2560);
        SWTHelper.setGridDataHeight((Control)this.lbJournal, 4, true);
        this.tk.adapt((Control)this.lbJournal, true, true);
        this.ecStatus.setClient((Control)this.lbJournal);
        this.ecFehler = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_errorMessages);
        this.ecFehler.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.tRejects = SWTHelper.createText(this.tk, (Composite)this.ecFehler, 4, 520);
        this.ecFehler.setClient((Control)this.tRejects);
        this.ecAusgaben = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_outputs);
        this.ecAusgaben.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.lbOutputs = new org.eclipse.swt.widgets.List((Composite)this.ecAusgaben, 2560);
        this.ecAusgaben.setClient((Control)this.lbOutputs);
        SWTHelper.setGridDataHeight((Control)this.lbOutputs, 4, true);
        this.tk.adapt((Control)this.lbOutputs, true, true);
        this.lbOutputs.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String[] selectedOutputTraces = RechnungsBlatt.this.lbOutputs.getSelection();
                if (selectedOutputTraces != null) {
                    String[] stringArray = selectedOutputTraces;
                    int n = selectedOutputTraces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String trace = stringArray[n2];
                        this.getOutputterForTrace(trace).ifPresent(o -> this.getOutputDateTime(trace).ifPresent(ot -> o.openOutput(RechnungsBlatt.this.actRn.toIInvoice(), ot.toLocalDateTime(), this.getOutputInvoiceState(trace))));
                        ++n2;
                    }
                }
            }

            private Optional<IRnOutputter> getOutputterForTrace(String trace) {
                List outputters = Extensions.getClasses((String)"ch.elexis.core.data.RechnungsManager", (String)"outputter");
                String description = this.getOutputterDescription(trace);
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    for (IRnOutputter iRnOutputter : outputters) {
                        if (!iRnOutputter.getDescription().equalsIgnoreCase(description)) continue;
                        return Optional.of(iRnOutputter);
                    }
                }
                return Optional.empty();
            }

            private String getOutputterDescription(String trace) {
                String[] parts;
                if (trace != null && (parts = trace.split(": ")) != null && parts.length >= 2) {
                    return parts[1].trim();
                }
                return null;
            }

            private InvoiceState getOutputInvoiceState(String trace) {
                String[] parts;
                if (trace != null && (parts = trace.split(": ")) != null && parts.length >= 3) {
                    InvoiceState[] invoiceStateArray = InvoiceState.values();
                    int n = invoiceStateArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InvoiceState state = invoiceStateArray[n2];
                        if (state.getLocaleText().equals(parts[2])) {
                            return state;
                        }
                        ++n2;
                    }
                }
                return null;
            }

            private Optional<TimeTool> getOutputDateTime(String trace) {
                TimeTool ret;
                String[] parts;
                if (trace != null && (parts = trace.split(": ")) != null && parts.length >= 1 && (ret = new TimeTool()).set(parts[0].trim())) {
                    return Optional.of(ret);
                }
                return Optional.empty();
            }
        });
        this.ecKons = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.Core_Consultations);
        this.ecKons.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.konsultationenViewer = new ListViewer((Composite)this.ecKons, 2816);
        this.ecKons.setClient((Control)this.konsultationenViewer.getList());
        this.konsultationenViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<Object> elements = new ArrayList<Object>();
                if (RechnungsBlatt.this.actRn != null) {
                    IInvoice invoice = (IInvoice)NoPoUtil.loadAsIdentifiable((PersistentObject)RechnungsBlatt.this.actRn, IInvoice.class).get();
                    for (IEncounter encounter : invoice.getEncounters()) {
                        elements.add(encounter);
                        for (IDiagnosisReference diagnose : encounter.getDiagnoses()) {
                            elements.add(diagnose);
                        }
                        for (IBilled verrechnet : encounter.getBilled()) {
                            elements.add(verrechnet);
                        }
                    }
                }
                return elements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.konsultationenViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEncounter) {
                    Money sum = new Money(0);
                    for (IBilled billed : ((IEncounter)element).getBilled()) {
                        sum.addMoney(billed.getTotal());
                    }
                    return String.valueOf(((IEncounter)element).getLabel()) + " (" + sum.toString() + ")";
                }
                if (element instanceof IDiagnosisReference) {
                    IDiagnosisReference diagnose = (IDiagnosisReference)element;
                    return "  - " + diagnose.getLabel();
                }
                if (element instanceof IBilled) {
                    IBilled billed = (IBilled)element;
                    return "  - " + billed.getAmount() + " " + billed.getLabel() + " (" + billed.getTotal().toString() + ")";
                }
                return element.toString();
            }
        });
        this.konsultationenViewer.setInput((Object)this);
        this.ecStorno = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_storno);
        this.ecStorno.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.stornoViewer = new ListViewer((Composite)this.ecStorno, 2816);
        this.ecStorno.setClient((Control)this.stornoViewer.getList());
        this.stornoViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List konsultationen;
                ArrayList<Object> elements = new ArrayList<Object>();
                if (RechnungsBlatt.this.actRn != null && ((konsultationen = RechnungsBlatt.this.actRn.getKonsultationen()) == null || konsultationen.isEmpty())) {
                    HashMap<IEncounter, List<IInvoiceBilled>> elementsMap = new HashMap<IEncounter, List<IInvoiceBilled>>();
                    StringBuilder sbHeadingLabel = new StringBuilder();
                    sbHeadingLabel.append(String.valueOf(Messages.Core_Bill) + " " + RechnungsBlatt.this.actRn.getDatumRn());
                    sbHeadingLabel.append(Messages.RechnungsBlatt_stornoLabel);
                    IQuery query = CoreModelServiceHolder.get().getQuery(IInvoiceBilled.class);
                    query.and((EStructuralFeature)ModelPackage.Literals.IINVOICE_BILLED__INVOICE, IQuery.COMPARATOR.EQUALS, NoPoUtil.loadAsIdentifiable((PersistentObject)RechnungsBlatt.this.actRn, IInvoice.class).get());
                    List vcList = query.execute();
                    Money sum = new Money(0);
                    for (IInvoiceBilled vc : vcList) {
                        sum.addMoney(vc.getTotal());
                        this.addToMap(vc, elementsMap);
                    }
                    Set keys = elementsMap.keySet();
                    for (IEncounter konsultation : keys) {
                        if (konsultation != null) {
                            elements.add(konsultation);
                        } else {
                            elements.add("?");
                        }
                        elements.addAll((Collection)elementsMap.get(konsultation));
                    }
                    sbHeadingLabel.append(sum.toString());
                    elements.add(0, sbHeadingLabel.toString());
                }
                return elements.toArray();
            }

            private void addToMap(IInvoiceBilled copy, HashMap<IEncounter, List<IInvoiceBilled>> elementsMap) {
                IEncounter encounter = copy.getEncounter();
                if (encounter != null) {
                    List<IInvoiceBilled> list = elementsMap.get(encounter);
                    if (list == null) {
                        list = new ArrayList<IInvoiceBilled>();
                    }
                    list.add(copy);
                    elementsMap.put(encounter, list);
                } else {
                    List<IInvoiceBilled> list = elementsMap.get(null);
                    if (list == null) {
                        list = new ArrayList<IInvoiceBilled>();
                    }
                    list.add(copy);
                    elementsMap.put(null, list);
                }
            }
        });
        this.stornoViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

            public String getText(Object element) {
                if (element instanceof IInvoiceBilled) {
                    IInvoiceBilled vc = (IInvoiceBilled)element;
                    return "  - " + vc.getAmount() + " " + vc.getLabel() + " (" + vc.getTotal().toString() + ")";
                }
                if (element instanceof Konsultation) {
                    return "Konsultation " + ((Konsultation)element).getDatum();
                }
                if (element instanceof IEncounter) {
                    return "Konsultation " + this.dateFormatter.format(((IEncounter)element).getDate());
                }
                return element.toString();
            }
        });
        this.stornoViewer.setInput((Object)this);
        List<IViewContribution> filtered = ViewContributionHelper.getFilteredAndPositionSortedContributions(this.detailComposites, 0);
        for (IViewContribution ivc : filtered) {
            ExpandableComposite ec = WidgetFactory.createExpandableComposite(this.tk, this.form, ivc.getLocalizedTitle());
            ec.setLayoutData((Object)new GridData(4, 128, true, false));
            ec.addExpansionListener((IExpansionListener)ecExpansionListener);
            Composite mainComposite = new Composite((Composite)ec, 0);
            mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite ret = ivc.initComposite(mainComposite);
            this.tk.adapt(ret);
            ec.setClient((Control)ret);
        }
        GlobalEventDispatcher.addActivationListener(this, site.getPart());
    }

    private void saveExpandedState(String field, boolean state) {
        if (state) {
            ConfigServiceHolder.setUser((String)("view/expandableComposites/states/" + field), (String)"1");
        } else {
            ConfigServiceHolder.setUser((String)("view/expandableComposites/states/" + field), (String)"2");
        }
    }

    private void setExpandedState(ExpandableComposite ec, String field) {
        String mode = ConfigServiceHolder.getUser((String)"view/expandableComposites/setting", (String)"3");
        if (mode.equals("1")) {
            ec.setExpanded(true);
        } else if (mode.equals("2")) {
            ec.setExpanded(false);
        } else {
            String state = ConfigServiceHolder.getUser((String)("view/expandableComposites/states/" + field), (String)"2");
            if (state.equals("2")) {
                ec.setExpanded(false);
            } else {
                ec.setExpanded(true);
            }
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, this.site.getPart());
        super.dispose();
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_rn, this.eeli_user, this.eeli_patient});
            Rechnung selected = (Rechnung)ElexisEventDispatcher.getSelected(Rechnung.class);
            if (selected != null) {
                this.doSelect(selected);
            }
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_rn, this.eeli_user, this.eeli_patient});
        }
    }

    private void doSelect(Rechnung rn) {
        this.actRn = rn;
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RechnungsBlatt.this.display();
            }
        });
    }

    public void display() {
        this.rnform.reload((PersistentObject)this.actRn);
        String[] outputsSelection = this.lbOutputs.getSelection();
        String[] journalSelection = this.lbJournal.getSelection();
        this.lbJournal.removeAll();
        this.lbOutputs.removeAll();
        if (this.actRn != null) {
            Kontakt adressat = this.actRn.getFall().getInvoiceRecipient();
            this.rnAdressat.setText(String.valueOf(Messages.RechnungsBlatt_adressee) + (adressat != null ? adressat.getLabel() : ""));
            this.form.setText(this.actRn.getLabel());
            List trace = this.actRn.getTrace("Status\u00e4nderung");
            for (String s : trace) {
                String[] stm = s.split("\\s*:\\s");
                StringBuilder sb = new StringBuilder();
                sb.append(stm[0]).append(" : ").append(RnStatus.getStatusText((int)Integer.parseInt(stm[1])));
                this.lbJournal.add(sb.toString());
            }
            if (journalSelection != null && journalSelection.length > 0) {
                int i = 0;
                while (i < this.lbJournal.getItemCount()) {
                    String[] stringArray = journalSelection;
                    int n = journalSelection.length;
                    int stm = 0;
                    while (stm < n) {
                        String selection = stringArray[stm];
                        if (this.lbJournal.getItem(i).equals(selection)) {
                            this.lbJournal.select(i);
                        }
                        ++stm;
                    }
                    ++i;
                }
            }
            if (this.actRn.getStatus() == InvoiceState.DEFECTIVE.numericValue()) {
                List rejects = this.actRn.getTrace("Zur\u00fcckgewiesen");
                StringBuilder rjj = new StringBuilder();
                for (Object r : rejects) {
                    rjj.append((String)r).append("\n------\n");
                }
                this.tRejects.setText(rjj.toString());
            } else {
                this.tRejects.setText("");
            }
            List outputs = this.actRn.getTrace("Ausgegeben");
            for (String o : outputs) {
                this.lbOutputs.add(o);
            }
            if (outputsSelection != null && outputsSelection.length > 0) {
                int i = 0;
                while (i < this.lbOutputs.getItemCount()) {
                    String[] stringArray = outputsSelection;
                    int n = outputsSelection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String selection = stringArray[n2];
                        if (this.lbOutputs.getItem(i).equals(selection)) {
                            this.lbOutputs.select(i);
                        }
                        ++n2;
                    }
                    ++i;
                }
            }
            this.tBemerkungen.setText(this.actRn.getBemerkung());
            this.tInternalRemarks.setText(this.actRn.getInternalRemarks());
        } else {
            this.rnAdressat.setText("");
            this.tRejects.setText("");
            this.form.setText(null);
        }
        this.attachments.getStructuredViewer().setInput((Object)this.actRn);
        this.buchungen.setInput((Object)this.actRn);
        this.konsultationenViewer.refresh();
        this.stornoViewer.refresh();
        this.detailComposites.forEach(dc -> dc.setDetailObject(this.actRn, null));
        this.setExpandedState(this.ecBuchungen, KEY_RECHNUNGSBLATT + this.ecBuchungen.getText());
        this.setExpandedState(this.ecBemerkungen, KEY_RECHNUNGSBLATT + this.ecBemerkungen.getText());
        this.setExpandedState(this.ecStatus, KEY_RECHNUNGSBLATT + this.ecStatus.getText());
        this.setExpandedState(this.ecFehler, KEY_RECHNUNGSBLATT + this.ecFehler.getText());
        this.setExpandedState(this.ecAusgaben, KEY_RECHNUNGSBLATT + this.ecAusgaben.getText());
        this.setExpandedState(this.ecKons, KEY_RECHNUNGSBLATT + this.ecKons.getText());
        this.setExpandedState(this.ecStorno, KEY_RECHNUNGSBLATT + this.ecStorno.getText());
        this.form.reflow(true);
    }
}

