/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.dto.InvoiceCorrectionDTO;
import ch.elexis.data.dto.InvoiceHistoryEntryDTO;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class InvoiceCorrectionWizard
extends Wizard {
    Page1 page1;
    Page2 page2;
    private InvoiceCorrectionDTO invoiceCorrectionDTO;

    public InvoiceCorrectionWizard(InvoiceCorrectionDTO invoiceCorrectionDTO) {
        this.setNeedsProgressMonitor(true);
        this.invoiceCorrectionDTO = invoiceCorrectionDTO;
    }

    public boolean performFinish() {
        return false;
    }

    public String getWindowTitle() {
        return "Rechnungskorrektur";
    }

    public void addPages() {
        this.page1 = new Page1(this.invoiceCorrectionDTO);
        this.page2 = new Page2(this.invoiceCorrectionDTO);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean canFinish() {
        return ((Object)((Object)this.page2)).equals(this.getContainer().getCurrentPage());
    }

    class Page1
    extends WizardPage {
        private Text text1;
        private Composite container;
        private InvoiceCorrectionDTO invoiceCorrectionDTO;

        protected Page1(InvoiceCorrectionDTO invoiceCorrectionDTO) {
            super("Rechnungskorrektur");
            this.setTitle("Rechnungskorrektur");
            this.setDescription("Anbei finden Sie eine \u00dcbersicht der get\u00e4tigten \u00c4nderungen.\nDurch das Best\u00e4tigen auf Rechnung erstellen werden die \u00c4nderungen \u00fcbernommen und eine neue Rechnung erstellt.");
            this.setControl((Control)this.text1);
            this.invoiceCorrectionDTO = invoiceCorrectionDTO;
        }

        public void createControl(Composite parent) {
            this.container = new Composite(parent, 0);
            this.container.setLayout((Layout)new GridLayout(1, false));
            TableViewer viewer = new TableViewer(this.container, 2828);
            viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.getTable().setLinesVisible(true);
            viewer.setInput((Object)this.invoiceCorrectionDTO.getHistory());
            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    int i = Page1.this.invoiceCorrectionDTO.getHistory().indexOf(element);
                    return String.valueOf(String.valueOf(++i)) + ".   " + ((InvoiceHistoryEntryDTO)element).getText();
                }
            });
            TableColumn singleColumn = new TableColumn(viewer.getTable(), 0);
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            tableColumnLayout.setColumnData((Widget)singleColumn, (ColumnLayoutData)new ColumnWeightData(100));
            this.container.setLayout((Layout)tableColumnLayout);
            this.setControl((Control)this.container);
            this.setPageComplete(!this.invoiceCorrectionDTO.getHistory().isEmpty());
        }
    }

    class Page2
    extends WizardPage {
        private Text txtOutput;
        private Text text1;
        private Composite container;
        private InvoiceCorrectionDTO invoiceCorrectionDTO;
        private CheckboxTableViewer viewer;

        protected Page2(InvoiceCorrectionDTO invoiceCorrectionDTO) {
            super("Rechnungskorrektur");
            this.setTitle("Rechnungskorrektur");
            this.setDescription("Folgende \u00c4nderungen wurden erfolgreich \u00fcbernommen.");
            this.setControl((Control)this.text1);
            this.invoiceCorrectionDTO = invoiceCorrectionDTO;
        }

        public void createControl(Composite parent) {
            this.container = new Composite(parent, 0);
            this.container.setLayout((Layout)new GridLayout(1, false));
            Composite tableComp = new Composite(this.container, 0);
            tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer = CheckboxTableViewer.newCheckList((Composite)tableComp, (int)2816);
            this.viewer.getTable().setLinesVisible(true);
            this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setInput((Object)this.invoiceCorrectionDTO.getHistory());
            this.viewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Page2.this.viewer.setChecked(event.getElement(), !event.getChecked());
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new WizardLabelProvider());
            TableColumn singleColumn = new TableColumn(this.viewer.getTable(), 0);
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            tableColumnLayout.setColumnData((Widget)singleColumn, (ColumnLayoutData)new ColumnWeightData(100));
            tableComp.setLayout((Layout)tableColumnLayout);
            Label lblOutput = new Label(this.container, 0);
            lblOutput.setText("Ausgabe");
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = 100;
            this.txtOutput = new Text(this.container, 2634);
            this.txtOutput.setLayoutData((Object)gd);
            this.setControl((Control)this.container);
            this.setPageComplete(!this.invoiceCorrectionDTO.getHistory().isEmpty());
        }

        public Text getTxtOutput() {
            return this.txtOutput;
        }

        public InvoiceCorrectionDTO getInvoiceCorrectionDTO() {
            return this.invoiceCorrectionDTO;
        }

        public void setChecked(Object element, boolean state) {
            this.viewer.setChecked(element, state);
            this.viewer.refresh(true);
        }

        public void updateProcess() {
            for (InvoiceHistoryEntryDTO invoiceHistoryEntryDTO : this.invoiceCorrectionDTO.getHistory()) {
                if (!invoiceHistoryEntryDTO.isIgnored()) {
                    this.setChecked(invoiceHistoryEntryDTO, Boolean.TRUE.equals(invoiceHistoryEntryDTO.isSuccess()));
                    continue;
                }
                this.viewer.remove((Object)invoiceHistoryEntryDTO);
            }
        }
    }

    class WizardLabelProvider
    extends LabelProvider
    implements IColorProvider {
        WizardLabelProvider() {
        }

        public Color getForeground(Object element) {
            return UiDesk.getColor("schwarz");
        }

        public Color getBackground(Object element) {
            InvoiceHistoryEntryDTO item = (InvoiceHistoryEntryDTO)element;
            if (item.isSuccess() == null) {
                return UiDesk.getColor("weiss");
            }
            if (Boolean.TRUE.equals(item.isSuccess())) {
                return UiDesk.getColorFromRGB("E2FFC3");
            }
            return UiDesk.getColorFromRGB("FFDDDD");
        }

        public String getText(Object element) {
            if (InvoiceCorrectionWizard.this.invoiceCorrectionDTO != null) {
                int i = InvoiceCorrectionWizard.this.invoiceCorrectionDTO.getHistory().indexOf(element);
                return String.valueOf(String.valueOf(++i)) + ".   " + ((InvoiceHistoryEntryDTO)element).getText();
            }
            return "";
        }
    }
}

