/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TimeSpanSelectionComposite
extends Composite
implements ISelectionProvider {
    private ListenerList selectionListeners = new ListenerList();
    private DateTime timespanFrom;
    private DateTime timespanTo;
    private TimeSpan timeSpan;

    public TimeSpanSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label((Composite)this, 0);
        label.setText("Von");
        this.timespanFrom = new DateTime((Composite)this, 0);
        this.timespanFrom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSpanSelectionComposite.this.updateTimeSpan(TimeSpanSelectionComposite.this.timespanFrom);
                TimeSpanSelectionComposite.this.callSelectionListeners();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText("Bis");
        this.timespanTo = new DateTime((Composite)this, 0);
        this.timespanTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSpanSelectionComposite.this.updateTimeSpan(TimeSpanSelectionComposite.this.timespanTo);
                TimeSpanSelectionComposite.this.callSelectionListeners();
            }
        });
    }

    private void updateTimeSpan(DateTime dateTime) {
        if (this.timeSpan == null) {
            this.timeSpan = new TimeSpan();
        }
        if (this.timespanFrom == dateTime) {
            this.setDateTime(dateTime, this.timeSpan.from);
        } else if (this.timespanTo == dateTime) {
            this.setDateTime(dateTime, this.timeSpan.until);
        }
    }

    public void setTimeSpan(TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
        if (timeSpan != null) {
            this.setDate(timeSpan.from, this.timespanFrom);
            this.setDate(timeSpan.until, this.timespanTo);
        }
    }

    private void setDate(TimeTool time, DateTime dateTime) {
        dateTime.setDay(time.get(5));
        dateTime.setMonth(time.get(2));
        dateTime.setYear(time.get(1));
    }

    private void setDateTime(DateTime dateTime, TimeTool time) {
        time.set(5, dateTime.getDay());
        time.set(2, dateTime.getMonth());
        time.set(1, dateTime.getYear());
    }

    private void callSelectionListeners() {
        Object[] listeners = this.selectionListeners.getListeners();
        if (listeners != null && listeners.length > 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ((ISelectionChangedListener)object).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
                ++n2;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.timeSpan != null) {
            return new StructuredSelection((Object)this.timeSpan);
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            if (!selection.isEmpty()) {
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof TimeSpan) {
                    this.setTimeSpan((TimeSpan)element);
                }
            } else {
                this.setTimeSpan(null);
            }
        }
    }
}

